/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.parsers;

import com.davidrandoll.spring_web_captor.body_parser.IRequestBodyParser;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.springframework.core.annotation.Order;
import org.springframework.util.ObjectUtils;

@Order(value=1)
public class JsonRequestBodyParser
implements IRequestBodyParser {
    private final ObjectMapper objectMapper;

    @Override
    public boolean supports(String contentType) {
        return contentType != null && contentType.contains("json");
    }

    @Override
    public BodyPayload parse(ServletRequest request, byte[] body) throws IOException {
        if (ObjectUtils.isEmpty((Object)body)) {
            return new BodyPayload((JsonNode)JsonNodeFactory.instance.nullNode());
        }
        return new BodyPayload(this.objectMapper.readTree(body));
    }

    @Generated
    public JsonRequestBodyParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

