/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.event;

import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.davidrandoll.spring_web_captor.event.HttpMethodEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class BaseHttpEvent {
    private boolean endpointExists;
    private String fullUrl;
    private String path;
    private HttpMethodEnum method;
    private HttpHeaders headers;
    private MultiValueMap<String, String> queryParams;
    private Map<String, String> pathParams;
    private BodyPayload bodyPayload;
    @JsonAnySetter
    @JsonAnyGetter
    private Map<String, Object> additionalData;

    public void addAdditionalData(@NonNull Map<String, Object> additionalData) {
        this.additionalData.putAll(additionalData);
    }

    public <T> void addAdditionalData(@NonNull String key, @NonNull T value) {
        this.additionalData.put(key, value);
    }

    @Nullable
    public <T> T getAdditionalData(String key, Class<T> type) {
        Object value = this.additionalData.get(key);
        if (value == null) {
            return null;
        }
        return type.cast(value);
    }

    public boolean hasAdditionalData(String key) {
        return this.additionalData.containsKey(key);
    }

    public void removeAdditionalData(String key) {
        this.additionalData.remove(key);
    }

    @NonNull
    public JsonNode getRequestBody() {
        if (Objects.isNull(this.bodyPayload)) {
            return JsonNodeFactory.instance.nullNode();
        }
        return this.bodyPayload.getBody();
    }

    @NonNull
    public MultiValueMap<String, MultipartFile> getRequestFiles() {
        if (Objects.isNull(this.bodyPayload) || Objects.isNull(this.bodyPayload.getFiles())) {
            return MultiValueMap.fromSingleValue(Map.of());
        }
        return this.bodyPayload.getFiles();
    }

    @Generated
    private static Map<String, Object> $default$additionalData() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected BaseHttpEvent(BaseHttpEventBuilder<?, ?> b) {
        this.endpointExists = b.endpointExists;
        this.fullUrl = b.fullUrl;
        this.path = b.path;
        this.method = b.method;
        this.headers = b.headers;
        this.queryParams = b.queryParams;
        this.pathParams = b.pathParams;
        this.bodyPayload = b.bodyPayload;
        this.additionalData = b.additionalData$set ? b.additionalData$value : BaseHttpEvent.$default$additionalData();
    }

    @Generated
    public static BaseHttpEventBuilder<?, ?> builder() {
        return new BaseHttpEventBuilderImpl();
    }

    @Generated
    public BaseHttpEventBuilder<?, ?> toBuilder() {
        return new BaseHttpEventBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean isEndpointExists() {
        return this.endpointExists;
    }

    @Generated
    public String getFullUrl() {
        return this.fullUrl;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public HttpMethodEnum getMethod() {
        return this.method;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Generated
    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    @Generated
    public BodyPayload getBodyPayload() {
        return this.bodyPayload;
    }

    @Generated
    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    @Generated
    public void setEndpointExists(boolean endpointExists) {
        this.endpointExists = endpointExists;
    }

    @Generated
    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setMethod(HttpMethodEnum method) {
        this.method = method;
    }

    @Generated
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Generated
    public void setQueryParams(MultiValueMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    @Generated
    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    @Generated
    public void setBodyPayload(BodyPayload bodyPayload) {
        this.bodyPayload = bodyPayload;
    }

    @Generated
    public void setAdditionalData(Map<String, Object> additionalData) {
        this.additionalData = additionalData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseHttpEvent)) {
            return false;
        }
        BaseHttpEvent other = (BaseHttpEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEndpointExists() != other.isEndpointExists()) {
            return false;
        }
        String this$fullUrl = this.getFullUrl();
        String other$fullUrl = other.getFullUrl();
        if (this$fullUrl == null ? other$fullUrl != null : !this$fullUrl.equals(other$fullUrl)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        HttpMethodEnum this$method = this.getMethod();
        HttpMethodEnum other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        MultiValueMap<String, String> this$queryParams = this.getQueryParams();
        MultiValueMap<String, String> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !this$queryParams.equals(other$queryParams)) {
            return false;
        }
        Map<String, String> this$pathParams = this.getPathParams();
        Map<String, String> other$pathParams = other.getPathParams();
        if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
            return false;
        }
        BodyPayload this$bodyPayload = this.getBodyPayload();
        BodyPayload other$bodyPayload = other.getBodyPayload();
        if (this$bodyPayload == null ? other$bodyPayload != null : !((Object)this$bodyPayload).equals(other$bodyPayload)) {
            return false;
        }
        Map<String, Object> this$additionalData = this.getAdditionalData();
        Map<String, Object> other$additionalData = other.getAdditionalData();
        return !(this$additionalData == null ? other$additionalData != null : !((Object)this$additionalData).equals(other$additionalData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseHttpEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEndpointExists() ? 79 : 97);
        String $fullUrl = this.getFullUrl();
        result = result * 59 + ($fullUrl == null ? 43 : $fullUrl.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        HttpMethodEnum $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        MultiValueMap<String, String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : $queryParams.hashCode());
        Map<String, String> $pathParams = this.getPathParams();
        result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        BodyPayload $bodyPayload = this.getBodyPayload();
        result = result * 59 + ($bodyPayload == null ? 43 : ((Object)$bodyPayload).hashCode());
        Map<String, Object> $additionalData = this.getAdditionalData();
        result = result * 59 + ($additionalData == null ? 43 : ((Object)$additionalData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseHttpEvent(endpointExists=" + this.isEndpointExists() + ", fullUrl=" + this.getFullUrl() + ", path=" + this.getPath() + ", method=" + String.valueOf((Object)this.getMethod()) + ", headers=" + String.valueOf(this.getHeaders()) + ", queryParams=" + String.valueOf(this.getQueryParams()) + ", pathParams=" + String.valueOf(this.getPathParams()) + ", bodyPayload=" + String.valueOf(this.getBodyPayload()) + ", additionalData=" + String.valueOf(this.getAdditionalData()) + ")";
    }

    @Generated
    public BaseHttpEvent() {
        this.additionalData = BaseHttpEvent.$default$additionalData();
    }

    @Generated
    public BaseHttpEvent(boolean endpointExists, String fullUrl, String path, HttpMethodEnum method, HttpHeaders headers, MultiValueMap<String, String> queryParams, Map<String, String> pathParams, BodyPayload bodyPayload, Map<String, Object> additionalData) {
        this.endpointExists = endpointExists;
        this.fullUrl = fullUrl;
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.queryParams = queryParams;
        this.pathParams = pathParams;
        this.bodyPayload = bodyPayload;
        this.additionalData = additionalData;
    }

    public static abstract class BaseHttpEventBuilder<C extends BaseHttpEvent, B extends BaseHttpEventBuilder<C, B>> {
        @Generated
        private boolean endpointExists;
        @Generated
        private String fullUrl;
        @Generated
        private String path;
        @Generated
        private HttpMethodEnum method;
        @Generated
        private HttpHeaders headers;
        @Generated
        private MultiValueMap<String, String> queryParams;
        @Generated
        private Map<String, String> pathParams;
        protected Map<String, Object> additionalData$value = new HashMap<String, Object>();
        private boolean additionalData$set;
        protected BodyPayload bodyPayload;

        public B additionalData(String key, Object value) {
            this.additionalData$set = true;
            this.additionalData$value.put(key, value);
            return this.self();
        }

        public B additionalData(Map<String, Object> values) {
            this.additionalData$set = true;
            this.additionalData$value.putAll(values);
            return this.self();
        }

        public B requestBody(JsonNode body) {
            if (this.bodyPayload == null) {
                this.bodyPayload = new BodyPayload(body);
            } else {
                this.bodyPayload.setBody(body);
            }
            return this.self();
        }

        @Generated
        protected B $fillValuesFrom(C instance) {
            BaseHttpEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BaseHttpEvent instance, BaseHttpEventBuilder<?, ?> b) {
            b.endpointExists(instance.endpointExists);
            b.fullUrl(instance.fullUrl);
            b.path(instance.path);
            b.method(instance.method);
            b.headers(instance.headers);
            b.queryParams(instance.queryParams);
            b.pathParams(instance.pathParams);
            b.bodyPayload(instance.bodyPayload);
            b.additionalData(instance.additionalData);
        }

        @Generated
        public B endpointExists(boolean endpointExists) {
            this.endpointExists = endpointExists;
            return this.self();
        }

        @Generated
        public B fullUrl(String fullUrl) {
            this.fullUrl = fullUrl;
            return this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return this.self();
        }

        @Generated
        public B method(HttpMethodEnum method) {
            this.method = method;
            return this.self();
        }

        @Generated
        public B headers(HttpHeaders headers) {
            this.headers = headers;
            return this.self();
        }

        @Generated
        public B queryParams(MultiValueMap<String, String> queryParams) {
            this.queryParams = queryParams;
            return this.self();
        }

        @Generated
        public B pathParams(Map<String, String> pathParams) {
            this.pathParams = pathParams;
            return this.self();
        }

        @Generated
        public B bodyPayload(BodyPayload bodyPayload) {
            this.bodyPayload = bodyPayload;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseHttpEvent.BaseHttpEventBuilder(endpointExists=" + this.endpointExists + ", fullUrl=" + this.fullUrl + ", path=" + this.path + ", method=" + String.valueOf((Object)this.method) + ", headers=" + String.valueOf(this.headers) + ", queryParams=" + String.valueOf(this.queryParams) + ", pathParams=" + String.valueOf(this.pathParams) + ", bodyPayload=" + String.valueOf(this.bodyPayload) + ", additionalData$value=" + String.valueOf(this.additionalData$value) + ")";
        }
    }

    @Generated
    private static final class BaseHttpEventBuilderImpl
    extends BaseHttpEventBuilder<BaseHttpEvent, BaseHttpEventBuilderImpl> {
        @Generated
        private BaseHttpEventBuilderImpl() {
        }

        @Override
        @Generated
        protected BaseHttpEventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BaseHttpEvent build() {
            return new BaseHttpEvent(this);
        }
    }

    @Generated
    public static final class Fields {
        public static final String endpointExists = "endpointExists";
        public static final String fullUrl = "fullUrl";
        public static final String path = "path";
        public static final String method = "method";
        public static final String headers = "headers";
        public static final String queryParams = "queryParams";
        public static final String pathParams = "pathParams";
        public static final String bodyPayload = "bodyPayload";
        public static final String additionalData = "additionalData";
    }
}

