/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.event;

import com.davidrandoll.spring_web_captor.event.BaseHttpEvent;
import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

public class HttpResponseEvent
extends BaseHttpEvent {
    private JsonNode responseBody;
    private HttpStatus responseStatus;
    private HttpHeaders responseHeaders;
    private Map<String, Object> errorDetail;

    public HttpResponseEvent(HttpRequestEvent requestEvent) {
        super(requestEvent.toBuilder());
    }

    public void addErrorDetail(@NonNull Map<String, Object> errorDetail) {
        this.errorDetail = errorDetail;
        String message = errorDetail.getOrDefault("message", "").toString();
        this.responseBody = JsonNodeFactory.instance.textNode(message);
    }

    public boolean isErrorResponse() {
        return this.responseStatus != null && (this.isClientErrorResponse() || this.isServerErrorResponse());
    }

    public boolean isServerErrorResponse() {
        return this.responseStatus != null && this.responseStatus.is5xxServerError();
    }

    public boolean isClientErrorResponse() {
        return this.responseStatus != null && this.responseStatus.is4xxClientError();
    }

    public boolean isSuccessResponse() {
        return this.responseStatus != null && this.responseStatus.is2xxSuccessful();
    }

    @Generated
    protected HttpResponseEvent(HttpResponseEventBuilder<?, ?> b) {
        super(b);
        this.responseBody = b.responseBody;
        this.responseStatus = b.responseStatus;
        this.responseHeaders = b.responseHeaders;
        this.errorDetail = b.errorDetail;
    }

    @Generated
    public static HttpResponseEventBuilder<?, ?> builder() {
        return new HttpResponseEventBuilderImpl();
    }

    @Generated
    public HttpResponseEventBuilder<?, ?> toBuilder() {
        return new HttpResponseEventBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public JsonNode getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public HttpStatus getResponseStatus() {
        return this.responseStatus;
    }

    @Generated
    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    @Generated
    public Map<String, Object> getErrorDetail() {
        return this.errorDetail;
    }

    @Generated
    public void setResponseBody(JsonNode responseBody) {
        this.responseBody = responseBody;
    }

    @Generated
    public void setResponseStatus(HttpStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    @Generated
    public void setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpResponseEvent(responseBody=" + String.valueOf(this.getResponseBody()) + ", responseStatus=" + String.valueOf(this.getResponseStatus()) + ", responseHeaders=" + String.valueOf(this.getResponseHeaders()) + ", errorDetail=" + String.valueOf(this.getErrorDetail()) + ")";
    }

    @Generated
    public HttpResponseEvent() {
    }

    @Generated
    public HttpResponseEvent(JsonNode responseBody, HttpStatus responseStatus, HttpHeaders responseHeaders, Map<String, Object> errorDetail) {
        this.responseBody = responseBody;
        this.responseStatus = responseStatus;
        this.responseHeaders = responseHeaders;
        this.errorDetail = errorDetail;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponseEvent)) {
            return false;
        }
        HttpResponseEvent other = (HttpResponseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonNode this$responseBody = this.getResponseBody();
        JsonNode other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        HttpStatus this$responseStatus = this.getResponseStatus();
        HttpStatus other$responseStatus = other.getResponseStatus();
        if (this$responseStatus == null ? other$responseStatus != null : !this$responseStatus.equals(other$responseStatus)) {
            return false;
        }
        HttpHeaders this$responseHeaders = this.getResponseHeaders();
        HttpHeaders other$responseHeaders = other.getResponseHeaders();
        if (this$responseHeaders == null ? other$responseHeaders != null : !this$responseHeaders.equals(other$responseHeaders)) {
            return false;
        }
        Map<String, Object> this$errorDetail = this.getErrorDetail();
        Map<String, Object> other$errorDetail = other.getErrorDetail();
        return !(this$errorDetail == null ? other$errorDetail != null : !((Object)this$errorDetail).equals(other$errorDetail));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpResponseEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonNode $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        HttpStatus $responseStatus = this.getResponseStatus();
        result = result * 59 + ($responseStatus == null ? 43 : $responseStatus.hashCode());
        HttpHeaders $responseHeaders = this.getResponseHeaders();
        result = result * 59 + ($responseHeaders == null ? 43 : $responseHeaders.hashCode());
        Map<String, Object> $errorDetail = this.getErrorDetail();
        result = result * 59 + ($errorDetail == null ? 43 : ((Object)$errorDetail).hashCode());
        return result;
    }

    public static abstract class HttpResponseEventBuilder<C extends HttpResponseEvent, B extends HttpResponseEventBuilder<C, B>>
    extends BaseHttpEvent.BaseHttpEventBuilder<C, B> {
        @Generated
        private JsonNode responseBody;
        @Generated
        private HttpStatus responseStatus;
        @Generated
        private HttpHeaders responseHeaders;
        @Generated
        private Map<String, Object> errorDetail;

        public B addErrorDetail(Map<String, Object> errorDetail) {
            if (errorDetail != null) {
                this.errorDetail(errorDetail);
                String message = errorDetail.getOrDefault("message", "").toString();
                this.responseBody((JsonNode)JsonNodeFactory.instance.textNode(message));
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HttpResponseEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(HttpResponseEvent instance, HttpResponseEventBuilder<?, ?> b) {
            b.responseBody(instance.responseBody);
            b.responseStatus(instance.responseStatus);
            b.responseHeaders(instance.responseHeaders);
            b.errorDetail(instance.errorDetail);
        }

        @Generated
        public B responseBody(JsonNode responseBody) {
            this.responseBody = responseBody;
            return (B)this.self();
        }

        @Generated
        public B responseStatus(HttpStatus responseStatus) {
            this.responseStatus = responseStatus;
            return (B)this.self();
        }

        @Generated
        public B responseHeaders(HttpHeaders responseHeaders) {
            this.responseHeaders = responseHeaders;
            return (B)this.self();
        }

        @Generated
        public B errorDetail(Map<String, Object> errorDetail) {
            this.errorDetail = errorDetail;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "HttpResponseEvent.HttpResponseEventBuilder(super=" + super.toString() + ", responseBody=" + String.valueOf(this.responseBody) + ", responseStatus=" + String.valueOf(this.responseStatus) + ", responseHeaders=" + String.valueOf(this.responseHeaders) + ", errorDetail=" + String.valueOf(this.errorDetail) + ")";
        }
    }

    @Generated
    private static final class HttpResponseEventBuilderImpl
    extends HttpResponseEventBuilder<HttpResponseEvent, HttpResponseEventBuilderImpl> {
        @Generated
        private HttpResponseEventBuilderImpl() {
        }

        @Override
        @Generated
        protected HttpResponseEventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HttpResponseEvent build() {
            return new HttpResponseEvent(this);
        }
    }

    @Generated
    public static final class Fields {
        public static final String responseBody = "responseBody";
        public static final String responseStatus = "responseStatus";
        public static final String responseHeaders = "responseHeaders";
        public static final String errorDetail = "errorDetail";
    }
}

