/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.field_captor.registry;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.field_captor.IRequestFieldCaptor;
import com.davidrandoll.spring_web_captor.field_captor.IResponseFieldCaptor;
import com.davidrandoll.spring_web_captor.field_captor.registry.IFieldCaptorRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class AbstractFieldCaptorRegistry
implements IFieldCaptorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFieldCaptorRegistry.class);
    protected final List<IRequestFieldCaptor> requestCaptors = new ArrayList<IRequestFieldCaptor>();
    protected final List<IResponseFieldCaptor> responseCaptors = new ArrayList<IResponseFieldCaptor>();

    @Override
    public void register(IRequestFieldCaptor captor) {
        this.requestCaptors.add(captor);
    }

    @Override
    public void register(IResponseFieldCaptor captor) {
        this.responseCaptors.add(captor);
    }

    protected List<IRequestFieldCaptor> getRequestCaptors() {
        return this.requestCaptors.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).toList();
    }

    protected List<IResponseFieldCaptor> getResponseCaptors() {
        return this.responseCaptors.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).toList();
    }

    @Override
    public HttpRequestEvent.HttpRequestEventBuilder<?, ?> capture(HttpServletRequest request, HttpRequestEvent.HttpRequestEventBuilder<?, ?> builder) {
        for (IRequestFieldCaptor captor : this.getRequestCaptors()) {
            try {
                captor.capture(request, builder);
            }
            catch (Exception e) {
                log.error("Error capturing request fields with captor: {}", (Object)captor.getClass().getName(), (Object)e);
            }
        }
        return builder;
    }

    @Override
    public HttpResponseEvent.HttpResponseEventBuilder<?, ?> capture(HttpServletResponse response, HttpResponseEvent.HttpResponseEventBuilder<?, ?> builder) {
        for (IResponseFieldCaptor captor : this.getResponseCaptors()) {
            try {
                captor.capture(response, builder);
            }
            catch (Exception e) {
                log.error("Error capturing response fields with captor: {}", (Object)captor.getClass().getName(), (Object)e);
            }
        }
        return builder;
    }
}

