/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.field_captor.registry;

import com.davidrandoll.spring_web_captor.body_parser.registry.IBodyParserRegistry;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestBodyCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestEndpointExistsCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestFullUrlCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestHeadersCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestMethodCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestPathCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestPathParamsCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.RequestQueryParamsCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.ResponseBodyCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.ResponseErrorCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.ResponseHeadersCaptor;
import com.davidrandoll.spring_web_captor.field_captor.captors.ResponseStatusCaptor;
import com.davidrandoll.spring_web_captor.field_captor.registry.AbstractFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.properties.WebCaptorProperties;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class DefaultFieldCaptorRegistry
extends AbstractFieldCaptorRegistry {
    public DefaultFieldCaptorRegistry(IBodyParserRegistry bodyParserRegistry, WebCaptorProperties.EventDetails properties, HandlerExceptionResolver resolver, DefaultErrorAttributes errorAttributes) {
        if (properties.isIncludeEndpointExists()) {
            this.register(new RequestEndpointExistsCaptor());
        }
        if (properties.isIncludeFullUrl()) {
            this.register(new RequestFullUrlCaptor());
        }
        if (properties.isIncludePath()) {
            this.register(new RequestPathCaptor());
        }
        if (properties.isIncludeMethod()) {
            this.register(new RequestMethodCaptor());
        }
        if (properties.isIncludeRequestHeaders()) {
            this.register(new RequestHeadersCaptor());
        }
        if (properties.isIncludeQueryParams()) {
            this.register(new RequestQueryParamsCaptor());
        }
        if (properties.isIncludePathParams()) {
            this.register(new RequestPathParamsCaptor());
        }
        if (properties.isIncludeRequestBody()) {
            this.register(new RequestBodyCaptor(bodyParserRegistry));
        }
        if (properties.isIncludeResponseStatus()) {
            this.register(new ResponseStatusCaptor());
        }
        if (properties.isIncludeResponseHeaders()) {
            this.register(new ResponseHeadersCaptor());
        }
        if (properties.isIncludeResponseBody()) {
            this.register(new ResponseBodyCaptor(bodyParserRegistry));
        }
        if (properties.isIncludeErrorDetails()) {
            this.register(new ResponseErrorCaptor(resolver, errorAttributes));
        }
    }
}

