/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publish_conditions;

import com.davidrandoll.spring_web_captor.event.HttpMethodEnum;
import com.davidrandoll.spring_web_captor.properties.WebCaptorProperties;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpRequestPublishCondition;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpResponsePublishCondition;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class ExcludedPathPublishCondition
implements IHttpRequestPublishCondition,
IHttpResponsePublishCondition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcludedPathPublishCondition.class);
    private final WebCaptorProperties properties;
    private final AntPathMatcher matcher;

    @Override
    public boolean shouldPublishRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.isExcluded(request.getMethod(), request.getRequestURI());
    }

    @Override
    public boolean shouldPublishResponse(HttpServletRequest request, HttpServletResponse response) {
        return this.isExcluded(request.getMethod(), request.getRequestURI());
    }

    private boolean isExcluded(String method, String path) {
        HttpMethodEnum requestMethod = HttpMethodEnum.fromValue(method);
        return this.properties.getExcludedEndpoints().stream().noneMatch(rule -> this.toMethods(rule.getMethod()).contains((Object)requestMethod) && this.matcher.match(rule.getPath(), path));
    }

    private List<HttpMethodEnum> toMethods(String method) {
        String cleaned;
        String string = cleaned = method == null ? "*" : method.replaceAll("\\s*", "").replaceAll("^,|,$", "").trim();
        if ("*".equalsIgnoreCase(cleaned)) {
            return List.of(HttpMethodEnum.values());
        }
        ArrayList<HttpMethodEnum> methods = new ArrayList<HttpMethodEnum>();
        for (String part : cleaned.split(",")) {
            try {
                methods.add(HttpMethodEnum.fromValue(part));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid HTTP method '{}' in excluded request configuration. Skipping.", (Object)part);
            }
        }
        return methods;
    }

    @Generated
    public ExcludedPathPublishCondition(WebCaptorProperties properties, AntPathMatcher matcher) {
        this.properties = properties;
        this.matcher = matcher;
    }
}

