/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.extensions.IHttpEventExtension;
import com.davidrandoll.spring_web_captor.field_captor.registry.IFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpRequestPublishCondition;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpResponsePublishCondition;
import com.davidrandoll.spring_web_captor.publisher.IHttpEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.IWebCaptorEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyHttpServletRequest;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class DefaultHttpEventPublisher
implements IHttpEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpEventPublisher.class);
    private final IWebCaptorEventPublisher publisher;
    private final List<IHttpEventExtension> httpEventExtensions;
    private final IFieldCaptorRegistry registry;
    private final List<IHttpRequestPublishCondition> requestPublishConditions;
    private final List<IHttpResponsePublishCondition> responsePublishConditions;

    @Override
    public void publishRequestEvent(HttpServletRequest request, HttpServletResponse response) {
        CachedBodyHttpServletRequest requestWrapper = HttpServletUtils.toCachedBodyHttpServletRequest(request);
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.toCachedBodyHttpServletResponse(response, requestWrapper);
        if (requestWrapper.isPublished()) {
            return;
        }
        HttpRequestEvent requestEvent = requestWrapper.toHttpRequestEvent(this.registry);
        for (IHttpEventExtension extension : this.httpEventExtensions) {
            try {
                Map<String, Object> additionalData = extension.enrichRequestEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, requestEvent);
                requestEvent.addAdditionalData(additionalData);
            }
            catch (Exception e) {
                log.error("Error enriching request event with extension: {}", (Object)extension.getClass().getName(), (Object)e);
            }
        }
        this.publisher.publishEvent(requestEvent);
        requestWrapper.markAsPublished();
    }

    @Override
    public void publishResponseEvent(HttpServletRequest request, HttpServletResponse response) {
        CachedBodyHttpServletRequest requestWrapper = HttpServletUtils.toCachedBodyHttpServletRequest(request);
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.toCachedBodyHttpServletResponse(response, requestWrapper);
        if (responseWrapper.isPublished()) {
            return;
        }
        HttpRequestEvent requestEvent = requestWrapper.toHttpRequestEvent(this.registry);
        HttpResponseEvent responseEvent = responseWrapper.toHttpResponseEvent(this.registry);
        for (IHttpEventExtension extension : this.httpEventExtensions) {
            try {
                Map<String, Object> additionalData = extension.enrichResponseEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, requestEvent, responseEvent);
                responseEvent.addAdditionalData(additionalData);
            }
            catch (Exception e) {
                log.error("Error enriching response event with extension: {}", (Object)extension.getClass().getName(), (Object)e);
            }
        }
        this.publisher.publishEvent(responseEvent);
        responseWrapper.markAsPublished();
    }

    @Override
    public boolean shouldPublishRequestEvent(HttpServletRequest request, HttpServletResponse response) {
        if (ObjectUtils.isEmpty(this.requestPublishConditions)) {
            return true;
        }
        return this.requestPublishConditions.stream().allMatch(condition -> condition.shouldPublishRequest(request, response));
    }

    @Override
    public boolean shouldPublishResponseEvent(HttpServletRequest request, HttpServletResponse response) {
        if (ObjectUtils.isEmpty(this.responsePublishConditions)) {
            return true;
        }
        return this.responsePublishConditions.stream().allMatch(condition -> condition.shouldPublishResponse(request, response));
    }

    @Generated
    public DefaultHttpEventPublisher(IWebCaptorEventPublisher publisher, List<IHttpEventExtension> httpEventExtensions, IFieldCaptorRegistry registry, List<IHttpRequestPublishCondition> requestPublishConditions, List<IHttpResponsePublishCondition> responsePublishConditions) {
        this.publisher = publisher;
        this.httpEventExtensions = httpEventExtensions;
        this.registry = registry;
        this.requestPublishConditions = requestPublishConditions;
        this.responsePublishConditions = responsePublishConditions;
    }
}

