/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.request;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CachedBodyServletInputStream
extends ServletInputStream {
    private final InputStream cachedBodyInputStream;

    public CachedBodyServletInputStream(byte[] cachedBody) {
        this.cachedBodyInputStream = new ByteArrayInputStream(cachedBody);
    }

    public int read() throws IOException {
        return this.cachedBodyInputStream.read();
    }

    public boolean isFinished() {
        try {
            return this.cachedBodyInputStream.available() == 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
    }
}

