/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.response;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.field_captor.registry.IFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyHttpServletRequest;
import com.davidrandoll.spring_web_captor.publisher.response.TeeHttpServletResponseWrapper;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class CachedBodyHttpServletResponse
extends TeeHttpServletResponseWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedBodyHttpServletResponse.class);
    private final CachedBodyHttpServletRequest request;
    private boolean isPublished = false;
    private HttpResponseEvent httpResponseEvent;
    private CompletableFuture<byte[]> responseBodyFuture;

    public CachedBodyHttpServletResponse(HttpServletResponse response, CachedBodyHttpServletRequest request) {
        super(response);
        this.request = request;
    }

    public CompletableFuture<byte[]> getResponseBody() throws IOException {
        if (this.responseBodyFuture != null) {
            return this.responseBodyFuture;
        }
        this.responseBodyFuture = new CompletableFuture();
        if (this.request.isAsyncStarted()) {
            this.request.getAsyncContext().addListener(new AsyncListener(){

                public void onComplete(AsyncEvent asyncEvent) throws IOException {
                    CachedBodyHttpServletResponse.this.getBody(CachedBodyHttpServletResponse.this.responseBodyFuture);
                }

                public void onTimeout(AsyncEvent asyncEvent) {
                    log.error("Async request timed out: {}", (Object)asyncEvent.getThrowable().getMessage(), (Object)asyncEvent.getThrowable());
                    CachedBodyHttpServletResponse.this.responseBodyFuture.completeExceptionally(new IOException("Async request timed out: " + asyncEvent.getThrowable().getMessage()));
                }

                public void onError(AsyncEvent asyncEvent) {
                    log.error("Error in async request: {}", (Object)asyncEvent.getThrowable().getMessage(), (Object)asyncEvent.getThrowable());
                    CachedBodyHttpServletResponse.this.responseBodyFuture.completeExceptionally(asyncEvent.getThrowable());
                }

                public void onStartAsync(AsyncEvent asyncEvent) {
                }
            });
        } else {
            this.getBody(this.responseBodyFuture);
        }
        return this.responseBodyFuture;
    }

    private void getBody(CompletableFuture<byte[]> future) throws IOException {
        future.complete(this.getCapturedResponseBody());
    }

    public HttpStatus getResponseStatus() {
        return HttpStatus.valueOf((int)this.getStatus());
    }

    public HttpResponseEvent toHttpResponseEvent(IFieldCaptorRegistry fieldCaptorRegistry) {
        if (Objects.nonNull(this.httpResponseEvent)) {
            return this.httpResponseEvent;
        }
        HttpRequestEvent requestEvent = this.request.toHttpRequestEvent(fieldCaptorRegistry);
        this.httpResponseEvent = fieldCaptorRegistry.capture((HttpServletResponse)this, (HttpResponseEvent.HttpResponseEventBuilder<?, ?>)new HttpResponseEvent(requestEvent).toBuilder()).build();
        return this.httpResponseEvent;
    }

    public void resolveException(Exception ex, HandlerExceptionResolver resolver) {
        this.resetBuffer();
        this.setContentType("application/json;charset=UTF-8");
        resolver.resolveException((HttpServletRequest)this.request, (HttpServletResponse)this, null, ex);
    }

    public void markAsPublished() {
        this.isPublished = true;
    }

    @Generated
    public CachedBodyHttpServletRequest getRequest() {
        return this.request;
    }

    @Generated
    public boolean isPublished() {
        return this.isPublished;
    }
}

