/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.response;

import com.davidrandoll.spring_web_captor.publisher.IHttpEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyHttpServletRequest;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpResponseEventPublisher
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpResponseEventPublisher.class);
    private final IHttpEventPublisher publisher;

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws IOException, ServletException {
        CachedBodyHttpServletRequest requestWrapper = HttpServletUtils.toCachedBodyHttpServletRequest(request);
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.toCachedBodyHttpServletResponse(response, requestWrapper);
        boolean shouldPublishRequest = this.publisher.shouldPublishRequestEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper);
        try {
            boolean shouldPublishResponse;
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            if (!requestWrapper.isPublished() && shouldPublishRequest) {
                this.publisher.publishRequestEvent(request, response);
            }
            if (shouldPublishResponse = this.publisher.shouldPublishResponseEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper)) {
                ((CompletableFuture)responseWrapper.getResponseBody().thenRun(() -> this.publisher.publishResponseEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper))).exceptionally(ex -> {
                    log.error("Failed to publish response event", ex);
                    return null;
                });
            }
        }
        catch (Exception ex2) {
            responseWrapper.getResponseBody().completeExceptionally(ex2);
            throw ex2;
        }
    }

    @Generated
    public HttpResponseEventPublisher(IHttpEventPublisher publisher) {
        this.publisher = publisher;
    }
}

