/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.parsers;

import com.davidrandoll.spring_web_captor.body_parser.IRequestBodyParser;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Order(value=1)
public class MultipartRequestBodyParser
implements IRequestBodyParser {
    private final boolean includeFiles;

    @Override
    public boolean supports(String contentType) {
        return contentType != null && contentType.contains("multipart");
    }

    @Override
    public BodyPayload parse(ServletRequest request, byte[] body) throws IOException {
        MultipartHttpServletRequest multipartRequest = MultipartRequestBodyParser.toMultipartHttpServletRequest(request);
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        multipartRequest.getParameterMap().forEach((key, values) -> {
            if (((String[])values).length == 1) {
                objectNode.put(key, values[0]);
            } else {
                ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
                for (String val : values) {
                    arrayNode.add(val);
                }
                objectNode.set(key, (JsonNode)arrayNode);
            }
        });
        if (!this.includeFiles) {
            return new BodyPayload((JsonNode)objectNode);
        }
        return new BodyPayload((JsonNode)objectNode, (MultiValueMap<String, MultipartFile>)multipartRequest.getMultiFileMap());
    }

    @NonNull
    private static MultipartHttpServletRequest toMultipartHttpServletRequest(ServletRequest request) {
        ServletRequest servletRequest = request;
        Objects.requireNonNull(servletRequest);
        ServletRequest servletRequest2 = servletRequest;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MultipartHttpServletRequest.class, HttpServletRequest.class}, (Object)servletRequest2, n)) {
            case 0 -> {
                MultipartHttpServletRequest multipartHttpServletRequest;
                yield multipartHttpServletRequest = (MultipartHttpServletRequest)servletRequest2;
            }
            case 1 -> {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest2;
                yield new StandardMultipartHttpServletRequest(httpServletRequest);
            }
            default -> throw new IllegalArgumentException("Request must be an instance of HttpServletRequest or MultipartHttpServletRequest");
        };
    }

    @Generated
    public MultipartRequestBodyParser(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }
}

