/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.parsers;

import com.davidrandoll.spring_web_captor.body_parser.IRequestBodyParser;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.annotation.Order;
import org.springframework.util.ObjectUtils;

@Order(value=0x7FFFFFFF)
public class TextRequestBodyParser
implements IRequestBodyParser {
    @Override
    public boolean supports(String contentType) {
        return true;
    }

    @Override
    public BodyPayload parse(ServletRequest request, byte[] body) throws IOException {
        if (ObjectUtils.isEmpty((Object)body)) {
            return new BodyPayload((JsonNode)JsonNodeFactory.instance.nullNode());
        }
        Charset charset = HttpServletUtils.getCharset(request.getContentType());
        String text = new String(body, charset);
        return new BodyPayload((JsonNode)JsonNodeFactory.instance.textNode(text));
    }
}

