/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.parsers;

import com.davidrandoll.spring_web_captor.body_parser.IResponseBodyParser;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.annotation.Order;
import org.springframework.util.ObjectUtils;

@Order(value=0x7FFFFFFF)
public class TextResponseBodyParser
implements IResponseBodyParser {
    @Override
    public boolean supports(String contentType) {
        return true;
    }

    @Override
    public BodyPayload parse(HttpServletResponse response, byte[] body) throws IOException {
        if (ObjectUtils.isEmpty((Object)body)) {
            return new BodyPayload((JsonNode)JsonNodeFactory.instance.nullNode());
        }
        Charset charset = HttpServletUtils.getCharset(response.getContentType());
        String text = new String(body, charset);
        return new BodyPayload((JsonNode)JsonNodeFactory.instance.textNode(text));
    }
}

