/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.registry;

import com.davidrandoll.spring_web_captor.body_parser.IRequestBodyParser;
import com.davidrandoll.spring_web_captor.body_parser.IResponseBodyParser;
import com.davidrandoll.spring_web_captor.body_parser.registry.IBodyParserRegistry;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class AbstractBodyParserRegistry
implements IBodyParserRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBodyParserRegistry.class);
    protected final List<IRequestBodyParser> requestBodyParsers = new ArrayList<IRequestBodyParser>();
    protected final List<IResponseBodyParser> responseBodyParsers = new ArrayList<IResponseBodyParser>();

    @Override
    public void register(IRequestBodyParser parser) {
        this.requestBodyParsers.add(parser);
    }

    @Override
    public void register(IResponseBodyParser parser) {
        this.responseBodyParsers.add(parser);
    }

    protected List<IRequestBodyParser> getRequestParsers() {
        return this.requestBodyParsers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).toList();
    }

    protected List<IResponseBodyParser> getResponseBodyParsers() {
        return this.responseBodyParsers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).toList();
    }

    @Override
    public BodyPayload parseRequest(ServletRequest request, byte[] body) {
        String contentType = request.getContentType();
        for (IRequestBodyParser parser : this.getRequestParsers()) {
            if (!parser.supports(contentType)) continue;
            try {
                return parser.parse(request, body);
            }
            catch (IOException e) {
                log.error("Error parsing body with parser: {}", (Object)parser.getClass().getName(), (Object)e);
            }
        }
        throw new IllegalStateException("No parser found for content type: " + contentType);
    }

    @Override
    public BodyPayload parseResponse(HttpServletResponse response, byte[] body) {
        String contentType = response.getContentType();
        for (IResponseBodyParser parser : this.getResponseBodyParsers()) {
            if (!parser.supports(contentType)) continue;
            try {
                return parser.parse(response, body);
            }
            catch (IOException e) {
                log.error("Error parsing response body with parser: {}", (Object)parser.getClass().getName(), (Object)e);
            }
        }
        throw new IllegalStateException("No parser found for content type: " + contentType);
    }
}

