/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.config;

import com.davidrandoll.spring_web_captor.body_parser.registry.DefaultBodyParserRegistry;
import com.davidrandoll.spring_web_captor.body_parser.registry.IBodyParserRegistry;
import com.davidrandoll.spring_web_captor.extensions.HttpDurationFilterExtension;
import com.davidrandoll.spring_web_captor.extensions.IHttpEventExtension;
import com.davidrandoll.spring_web_captor.extensions.IpAddressHttpEventExtension;
import com.davidrandoll.spring_web_captor.extensions.UserAgentHttpEventExtension;
import com.davidrandoll.spring_web_captor.field_captor.registry.DefaultFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.field_captor.registry.IFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.properties.IsDurationEnabled;
import com.davidrandoll.spring_web_captor.properties.IsIpAddressEnabled;
import com.davidrandoll.spring_web_captor.properties.IsUserAgentEnabled;
import com.davidrandoll.spring_web_captor.properties.IsWebCaptorEnabled;
import com.davidrandoll.spring_web_captor.properties.WebCaptorProperties;
import com.davidrandoll.spring_web_captor.publish_conditions.ExcludedPathPublishCondition;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpRequestPublishCondition;
import com.davidrandoll.spring_web_captor.publish_conditions.IHttpResponsePublishCondition;
import com.davidrandoll.spring_web_captor.publisher.DefaultHttpEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.DefaultWebCaptorEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.IHttpEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.IWebCaptorEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.request.HttpRequestEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.response.HttpResponseEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.response.RuntimeExceptionResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Configuration
public class AppConfig {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={IsWebCaptorEnabled.class})
    public IWebCaptorEventPublisher webCaptorEventPublisher(ApplicationEventPublisher publisher) {
        return new DefaultWebCaptorEventPublisher(publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={IsWebCaptorEnabled.class})
    public IBodyParserRegistry bodyParserRegistry(ObjectMapper objectMapper, WebCaptorProperties properties) {
        return new DefaultBodyParserRegistry(objectMapper, properties.getEventDetails());
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={IsWebCaptorEnabled.class})
    public IHttpEventPublisher httpEventPublisher(IWebCaptorEventPublisher publisher, List<IHttpEventExtension> extensions, IFieldCaptorRegistry fieldCaptorRegistry, List<IHttpRequestPublishCondition> requestPublishConditions, List<IHttpResponsePublishCondition> responsePublishConditions) {
        return new DefaultHttpEventPublisher(publisher, extensions, fieldCaptorRegistry, requestPublishConditions, responsePublishConditions);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={IsWebCaptorEnabled.class})
    public IFieldCaptorRegistry fieldCaptorRegistry(IBodyParserRegistry bodyParserRegistry, WebCaptorProperties properties, @Lazy @Qualifier(value="handlerExceptionResolver") HandlerExceptionResolver resolver, DefaultErrorAttributes errorAttributes) {
        return new DefaultFieldCaptorRegistry(bodyParserRegistry, properties.getEventDetails(), resolver, errorAttributes);
    }

    @Bean(value={"httpDurationFilterExtension"})
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(name={"httpDurationFilterExtension"}, ignored={HttpDurationFilterExtension.class})
    @Conditional(value={IsWebCaptorEnabled.class, IsDurationEnabled.class})
    public HttpDurationFilterExtension httpDurationFilterExtension() {
        return new HttpDurationFilterExtension();
    }

    @Bean(value={"ipAddressHttpEventExtension"})
    @ConditionalOnMissingBean(name={"ipAddressHttpEventExtension"}, ignored={IpAddressHttpEventExtension.class})
    @Conditional(value={IsWebCaptorEnabled.class, IsIpAddressEnabled.class})
    public IpAddressHttpEventExtension ipAddressHttpEventExtension() {
        return new IpAddressHttpEventExtension();
    }

    @Bean(value={"userAgentHttpEventExtension"})
    @ConditionalOnMissingBean(name={"userAgentHttpEventExtension"}, ignored={UserAgentHttpEventExtension.class})
    @Conditional(value={IsWebCaptorEnabled.class, IsUserAgentEnabled.class})
    public UserAgentHttpEventExtension userAgentHttpEventExtension() {
        return new UserAgentHttpEventExtension();
    }

    @Bean(value={"httpResponseEventPublisher"})
    @Order(value=-2147483647)
    @ConditionalOnMissingBean(name={"httpResponseEventPublisher"}, ignored={HttpResponseEventPublisher.class})
    @Conditional(value={IsWebCaptorEnabled.class})
    public HttpResponseEventPublisher httpResponseEventPublisher(IHttpEventPublisher publisher) {
        return new HttpResponseEventPublisher(publisher);
    }

    @Bean(value={"httpRequestEventPublisher"})
    @ConditionalOnMissingBean(name={"httpRequestEventPublisher"}, ignored={HttpRequestEventPublisher.class})
    @Conditional(value={IsWebCaptorEnabled.class})
    public HttpRequestEventPublisher httpRequestEventPublisher(IHttpEventPublisher publisher) {
        return new HttpRequestEventPublisher(publisher);
    }

    @Bean(value={"runtimeExceptionResolver"})
    @ConditionalOnMissingBean(name={"runtimeExceptionResolver"}, ignored={RuntimeExceptionResolver.class})
    @Conditional(value={IsWebCaptorEnabled.class})
    public RuntimeExceptionResolver runtimeExceptionResolver(ObjectMapper mapper) {
        return new RuntimeExceptionResolver(mapper);
    }

    @Bean(value={"excludedPathPublishCondition"})
    @ConditionalOnMissingBean(name={"excludedPathPublishCondition"}, ignored={ExcludedPathPublishCondition.class})
    @Conditional(value={IsWebCaptorEnabled.class})
    public ExcludedPathPublishCondition excludedPathPublishCondition(WebCaptorProperties properties) {
        return new ExcludedPathPublishCondition(properties, new AntPathMatcher());
    }
}

