/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.config;

import com.davidrandoll.spring_web_captor.properties.IsWebCaptorEnabled;
import com.davidrandoll.spring_web_captor.publisher.request.HttpRequestEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.response.RuntimeExceptionResolver;
import java.util.List;
import lombok.Generated;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="webCaptorWebConfig")
@EnableWebMvc
@Conditional(value={IsWebCaptorEnabled.class})
public class WebConfig
implements WebMvcConfigurer {
    private final HttpRequestEventPublisher httpRequestEventPublisher;
    private final RuntimeExceptionResolver runtimeExceptionResolver;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.httpRequestEventPublisher).addPathPatterns(new String[]{"/**"});
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        resolvers.add(this.runtimeExceptionResolver);
    }

    @Generated
    public WebConfig(HttpRequestEventPublisher httpRequestEventPublisher, RuntimeExceptionResolver runtimeExceptionResolver) {
        this.httpRequestEventPublisher = httpRequestEventPublisher;
        this.runtimeExceptionResolver = runtimeExceptionResolver;
    }
}

