/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.extensions;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.extensions.IHttpEventExtension;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpDurationFilterExtension
extends OncePerRequestFilter
implements IHttpEventExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpDurationFilterExtension.class);
    private static final String START_TIME_KEY = "startTime";
    private static final String END_TIME_KEY = "endTime";
    private static final String DURATION_KEY = "duration";

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        request.setAttribute(START_TIME_KEY, (Object)System.currentTimeMillis());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public Map<String, Object> enrichResponseEvent(HttpServletRequest req, HttpServletResponse res, HttpRequestEvent reqEvent, HttpResponseEvent resEvent) {
        Object startTimeObj = req.getAttribute(START_TIME_KEY);
        if (!(startTimeObj instanceof Long)) {
            return Map.of();
        }
        Long startTime = (Long)startTimeObj;
        long endTime = System.currentTimeMillis();
        Duration duration = Duration.ofMillis(endTime - startTime);
        return Map.of(DURATION_KEY, duration, START_TIME_KEY, startTime, END_TIME_KEY, endTime);
    }
}

