/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.extensions;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.extensions.IHttpEventExtension;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressHttpEventExtension
implements IHttpEventExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpAddressHttpEventExtension.class);
    private static final String USER_IP = "userIp";

    @Override
    public Map<String, Object> enrichRequestEvent(HttpServletRequest req, HttpServletResponse res, HttpRequestEvent event) {
        return this.getUserIp(req);
    }

    @Override
    public Map<String, Object> enrichResponseEvent(HttpServletRequest req, HttpServletResponse res, HttpRequestEvent reqEvent, HttpResponseEvent resEvent) {
        return this.getUserIp(req);
    }

    private Map<String, Object> getUserIp(HttpServletRequest request) {
        try {
            String ipAddress = HttpServletUtils.getClientIpAddressIfServletRequestExist(request);
            return Map.of(USER_IP, ipAddress);
        }
        catch (Exception e) {
            log.error("Error getting client details", (Throwable)e);
            return Map.of();
        }
    }

    @Generated
    public IpAddressHttpEventExtension() {
    }
}

