/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.extensions;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.extensions.IHttpEventExtension;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentHttpEventExtension
implements IHttpEventExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAgentHttpEventExtension.class);
    private static final String USER_AGENT = "userAgent";

    @Override
    public Map<String, Object> enrichRequestEvent(HttpServletRequest req, HttpServletResponse res, HttpRequestEvent event) {
        return this.getUserAgent(req);
    }

    @Override
    public Map<String, Object> enrichResponseEvent(HttpServletRequest req, HttpServletResponse res, HttpRequestEvent reqEvent, HttpResponseEvent resEvent) {
        return this.getUserAgent(req);
    }

    private Map<String, Object> getUserAgent(HttpServletRequest request) {
        try {
            String userAgent = Optional.ofNullable(request.getHeader("User-Agent")).orElse("Unknown");
            return Map.of(USER_AGENT, userAgent);
        }
        catch (Exception e) {
            log.error("Error getting client details", (Throwable)e);
            return Map.of();
        }
    }

    @Generated
    public UserAgentHttpEventExtension() {
    }
}

