/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.field_captor.captors;

import com.davidrandoll.spring_web_captor.body_parser.registry.IBodyParserRegistry;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.field_captor.IResponseFieldCaptor;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ResponseBodyCaptor
implements IResponseFieldCaptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyCaptor.class);
    private final IBodyParserRegistry bodyParserRegistry;

    @Override
    public void capture(HttpServletResponse response, HttpResponseEvent.HttpResponseEventBuilder<?, ?> builder) {
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.castToCachedBodyHttpServletResponse(response);
        HttpStatus responseStatus = responseWrapper.getResponseStatus();
        try {
            if (responseStatus.is2xxSuccessful()) {
                responseWrapper.getResponseBody().thenAccept(body -> {
                    BodyPayload payload = this.bodyParserRegistry.parseResponse((HttpServletResponse)responseWrapper, (byte[])body);
                    builder.responseBody(payload.getBody());
                });
            }
        }
        catch (IOException e) {
            log.error("Error getting response body", (Throwable)e);
        }
    }

    @Generated
    public ResponseBodyCaptor(IBodyParserRegistry bodyParserRegistry) {
        this.bodyParserRegistry = bodyParserRegistry;
    }
}

