/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.field_captor.captors;

import com.davidrandoll.spring_web_captor.event.HttpResponseEvent;
import com.davidrandoll.spring_web_captor.field_captor.IResponseFieldCaptor;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class ResponseErrorCaptor
implements IResponseFieldCaptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseErrorCaptor.class);
    private final HandlerExceptionResolver resolver;
    private final DefaultErrorAttributes errorAttributes;

    @Override
    public void capture(HttpServletResponse response, HttpResponseEvent.HttpResponseEventBuilder<?, ?> builder) {
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.castToCachedBodyHttpServletResponse(response);
        HttpStatus responseStatus = responseWrapper.getResponseStatus();
        try {
            responseWrapper.getResponseBody().exceptionally(throwable -> {
                RuntimeException ex = new RuntimeException((Throwable)throwable);
                responseWrapper.resolveException(ex, this.resolver);
                Map<String, Object> errorDetails = this.getErrorDetails(responseWrapper);
                builder.addErrorDetail(errorDetails);
                return null;
            });
            if (!responseStatus.is2xxSuccessful()) {
                Map<String, Object> errorDetails = this.getErrorDetails(responseWrapper);
                builder.addErrorDetail(errorDetails);
            }
        }
        catch (IOException e) {
            log.error("Error getting response body", (Throwable)e);
        }
    }

    public Map<String, Object> getErrorDetails(CachedBodyHttpServletResponse responseWrapper) {
        ServletWebRequest webRequest = new ServletWebRequest((HttpServletRequest)responseWrapper.getRequest());
        ErrorAttributeOptions options = ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])ErrorAttributeOptions.Include.values());
        return this.errorAttributes.getErrorAttributes((WebRequest)webRequest, options);
    }

    @Generated
    public ResponseErrorCaptor(HandlerExceptionResolver resolver, DefaultErrorAttributes errorAttributes) {
        this.resolver = resolver;
        this.errorAttributes = errorAttributes;
    }
}

