/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.request;

import com.davidrandoll.spring_web_captor.event.HttpRequestEvent;
import com.davidrandoll.spring_web_captor.field_captor.registry.IFieldCaptorRegistry;
import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyServletInputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class CachedBodyHttpServletRequest
extends ContentCachingRequestWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedBodyHttpServletRequest.class);
    private byte[] cachedBody;
    private boolean endpointExists;
    private boolean isPublished = false;
    private HttpRequestEvent httpRequestEvent;

    public CachedBodyHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public boolean isErrorController() {
        return this.getRequestURI().equalsIgnoreCase("/error");
    }

    @NonNull
    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedBody != null) {
            return new CachedBodyServletInputStream(this.cachedBody);
        }
        byte[] cached = super.getContentAsByteArray();
        if (cached.length > 0) {
            this.cachedBody = cached;
        } else {
            ServletInputStream inputStream = super.getInputStream();
            this.cachedBody = StreamUtils.copyToByteArray((InputStream)inputStream);
        }
        return new CachedBodyServletInputStream(this.cachedBody);
    }

    public byte[] getCachedBody() {
        if (this.cachedBody == null) {
            this.getInputStream();
        }
        return this.cachedBody;
    }

    public HttpRequestEvent toHttpRequestEvent(IFieldCaptorRegistry registry) {
        if (Objects.nonNull(this.httpRequestEvent)) {
            return this.httpRequestEvent;
        }
        this.httpRequestEvent = registry.capture((HttpServletRequest)this, HttpRequestEvent.builder()).build();
        return this.httpRequestEvent;
    }

    public void markAsPublished() {
        this.isPublished = true;
    }

    @Generated
    public boolean isEndpointExists() {
        return this.endpointExists;
    }

    @Generated
    public void setEndpointExists(boolean endpointExists) {
        this.endpointExists = endpointExists;
    }

    @Generated
    public boolean isPublished() {
        return this.isPublished;
    }
}

