/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.request;

import com.davidrandoll.spring_web_captor.publisher.IHttpEventPublisher;
import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyHttpServletRequest;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import com.davidrandoll.spring_web_captor.utils.HttpServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;

public class HttpRequestEventPublisher
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestEventPublisher.class);
    private final IHttpEventPublisher publisher;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        CachedBodyHttpServletRequest requestWrapper = HttpServletUtils.toCachedBodyHttpServletRequest(request);
        CachedBodyHttpServletResponse responseWrapper = HttpServletUtils.toCachedBodyHttpServletResponse(response, requestWrapper);
        requestWrapper.setEndpointExists(true);
        boolean shouldPublishRequest = this.publisher.shouldPublishRequestEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper);
        if (!requestWrapper.isErrorController() && shouldPublishRequest) {
            this.publisher.publishRequestEvent((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper);
        }
        return true;
    }

    @Generated
    public HttpRequestEventPublisher(IHttpEventPublisher publisher) {
        this.publisher = publisher;
    }
}

