/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.publisher.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class RuntimeExceptionResolver
implements HandlerExceptionResolver {
    private final ObjectMapper mapper;

    public ModelAndView resolveException(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object handler, @NonNull Exception ex) {
        if (ex instanceof RuntimeException) {
            try {
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setContentType("application/json");
                HashMap<String, Object> body = new HashMap<String, Object>();
                body.put("error", HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
                body.put("message", ex.getMessage());
                body.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
                body.put("path", request.getRequestURI());
                body.put("timestamp", System.currentTimeMillis());
                this.mapper.writeValue((Writer)response.getWriter(), body);
                return new ModelAndView();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Generated
    public RuntimeExceptionResolver(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

