/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.utils;

import com.davidrandoll.spring_web_captor.publisher.request.CachedBodyHttpServletRequest;
import com.davidrandoll.spring_web_captor.publisher.response.CachedBodyHttpServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HttpServletUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServletUtils.class);
    public static final String DEFAULT_IP = "0.0.0.0";
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "X-Real-IP"};

    public static CachedBodyHttpServletResponse castToCachedBodyHttpServletResponse(@NonNull HttpServletResponse response) {
        if (response instanceof CachedBodyHttpServletResponse) {
            CachedBodyHttpServletResponse cachedBodyHttpServletResponse = (CachedBodyHttpServletResponse)response;
            return cachedBodyHttpServletResponse;
        }
        throw new ClassCastException("Response is not an instance of CachedBodyHttpServletResponse");
    }

    public static CachedBodyHttpServletRequest toCachedBodyHttpServletRequest(@NonNull HttpServletRequest request) {
        if (request instanceof CachedBodyHttpServletRequest) {
            CachedBodyHttpServletRequest cachedBodyHttpServletRequest = (CachedBodyHttpServletRequest)request;
            return cachedBodyHttpServletRequest;
        }
        return new CachedBodyHttpServletRequest(request);
    }

    public static CachedBodyHttpServletResponse toCachedBodyHttpServletResponse(@NonNull HttpServletResponse response, CachedBodyHttpServletRequest requestWrapper) {
        if (response instanceof CachedBodyHttpServletResponse) {
            CachedBodyHttpServletResponse cachedBodyHttpServletResponse = (CachedBodyHttpServletResponse)response;
            return cachedBodyHttpServletResponse;
        }
        return new CachedBodyHttpServletResponse(response, requestWrapper);
    }

    @NonNull
    public static String getClientIpAddressIfServletRequestExist(HttpServletRequest request) {
        if (request == null) {
            return DEFAULT_IP;
        }
        String ip = null;
        for (String header : IP_HEADER_CANDIDATES) {
            String ipList = request.getHeader(header);
            if (ipList == null || ipList.isEmpty() || "unknown".equalsIgnoreCase(ipList)) continue;
            ip = ipList.split(",")[0];
            break;
        }
        if (ip == null) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.equals("0:0:0:0:0:0:0:1")) {
            ip = "127.0.0.1";
        }
        return Optional.ofNullable(ip).map(String::trim).orElse(DEFAULT_IP);
    }

    @NonNull
    public static String getClientIpAddressIfServletRequestExist() {
        HttpServletRequest request = HttpServletUtils.getCurrentHttpRequest();
        return HttpServletUtils.getClientIpAddressIfServletRequestExist(request);
    }

    @Nullable
    public static HttpServletRequest getCurrentHttpRequest() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)attributes).getRequest();
    }

    public static Charset getCharset(String contentType) {
        Charset charset = null;
        if (contentType != null) {
            try {
                MediaType mediaType = MediaType.parseMediaType((String)contentType);
                if (mediaType.getCharset() != null) {
                    charset = mediaType.getCharset();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
    }

    @Generated
    private HttpServletUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

