/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class AnyInputStreamReader
extends Reader {
    private static final String ENCODING_HEAD = "#encoding:";
    private static final int MAX_ENCODING_LINE = 80;
    private final Reader in;
    private String encoding;

    public AnyInputStreamReader(InputStream is, String defenc) throws UnsupportedEncodingException, IOException {
        this.encoding = defenc;
        try {
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            is.mark(80);
            char[] buf = new char[80];
            String firstLine = null;
            for (int i = 0; i < 80; ++i) {
                int c = is.read();
                if (c == 13 || c == 10 || c < 0) {
                    firstLine = new String(buf, 0, i);
                    break;
                }
                buf[i] = (char)c;
            }
            if (firstLine != null && firstLine.startsWith(ENCODING_HEAD)) {
                this.encoding = firstLine.substring(ENCODING_HEAD.length()).trim();
            }
            is.reset();
            this.in = new InputStreamReader(is, this.encoding);
        }
        catch (IOException e) {
            try {
                is.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw e;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getEncoding() {
        return this.encoding;
    }
}

