/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.observation.EventIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFontCache<T> {
    private final ReferenceQueue<T> reaped = new ReferenceQueue();
    private final Map<String, ValueRef<T>> contents = new HashMap<String, ValueRef<T>>();

    public void destroy() {
        this.clear();
    }

    public abstract void onEvent(EventIterator var1);

    public T get(Object key) {
        ValueRef<T> vr = this.contents.get(key);
        return vr != null ? (T)vr.get() : null;
    }

    public T put(String key, T value) {
        this.reap();
        ValueRef<T> vr = new ValueRef<T>(value, key, this.reaped);
        return this.dereference(this.contents.put(key, vr));
    }

    public void putAll(Map<String, T> baseMap) {
        this.reap();
        for (Map.Entry<String, T> entry : baseMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        this.reap();
        return this.dereference(this.contents.remove(key));
    }

    public void clear() {
        this.reap();
        this.contents.clear();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + super.toString();
    }

    public void reap() {
        ValueRef ref;
        while ((ref = (ValueRef)this.reaped.poll()) != null) {
            this.contents.remove(ref.key);
            ref.key = null;
        }
    }

    private T dereference(ValueRef<T> ref) {
        if (ref != null) {
            Object result = ref.get();
            ref.clear();
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueRef<T>
    extends WeakReference<T> {
        private Object key;

        ValueRef(T val, Object key, ReferenceQueue<T> q) {
            super(val, q);
            this.key = key;
        }

        public int hashCode() {
            Object r = this.get();
            return r != null ? r.hashCode() : super.hashCode();
        }

        public boolean equals(Object obj) {
            Object r = this.get();
            if (r == obj) {
                return true;
            }
            if (r == null) {
                return false;
            }
            return r.equals(obj);
        }
    }
}

