/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font.fonter;

import com.day.any.AnyObject;
import com.day.any.AnyValue;
import com.day.any.ParseException;
import com.day.image.Layer;
import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;
import com.day.image.internal.font.fonter.FontDescriptor;
import com.day.image.internal.font.fonter.FonterFontCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FonterFont
extends AbstractFont {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Color TRANSPARENT_BACKGROUND = new Color(0, true);
    static ResourceResolver ticket;
    static String[] fontPath;
    static FonterFontCache fontCache;
    static final BandCombineOp convertToTransparent;
    private final String family;
    private final int size;
    private final int style;
    private final FontDescriptor fontInfo;

    static void init(ResourceResolver ticket, String[] fontPath) {
        FonterFont.ticket = ticket;
        FonterFont.fontPath = fontPath;
        fontCache = new FonterFontCache(fontPath);
    }

    static void destroy() {
        if (fontCache != null) {
            fontCache.destroy();
            fontCache = null;
        }
        fontPath = null;
        ticket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FonterFont(String faceName, int size, int style) {
        this.family = faceName;
        this.size = size;
        this.style = style;
        String fontName = FonterFont.createFontFileName(faceName, size, style);
        FonterFontCache fonterFontCache = fontCache;
        synchronized (fonterFontCache) {
            FontDescriptor fontInfo = (FontDescriptor)fontCache.get(fontName);
            if (fontInfo == null) {
                this.log.debug("FonterFont: Loading uncached font " + fontName);
                fontInfo = new FontDescriptor(ticket, fontPath, fontName);
                fontCache.put(fontName, fontInfo);
            } else {
                this.log.debug("FonterFont: Using cached font " + fontName);
            }
            this.fontInfo = fontInfo;
        }
    }

    @Override
    public Font getAwtFont() {
        return null;
    }

    @Override
    public double getAscent() {
        return this.fontInfo.ascent / 16;
    }

    @Override
    public double getDescent() {
        return this.fontInfo.descent / 16;
    }

    @Override
    public double getHeight() {
        return this.fontInfo.height / 16;
    }

    @Override
    public boolean canDisplay(char c) {
        return this.fontInfo.hasCharInfo(c);
    }

    @Override
    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        char c = iter.setIndex(start);
        while (iter.getIndex() < limit && this.canDisplay(c)) {
            c = iter.next();
        }
        int result = iter.getIndex();
        return result == limit ? -1 : result;
    }

    @Override
    public int canDisplayUpTo(String str) {
        return this.canDisplayUpTo(new StringCharacterIterator(str), 0, str.length());
    }

    @Override
    public int canDisplayUpTo(char[] text, int start, int limit) {
        while (start < limit && this.canDisplay(text[start])) {
            ++start;
        }
        return start == limit ? -1 : start;
    }

    @Override
    public Rectangle2D getTextExtent(int x, int y, int width, int height, String text, int align, double cs, int ls) {
        char c;
        if (text == null || text.length() == 0) {
            this.log.info("getTextExtent: No text to calculate");
            return new Rectangle(0, 0, 0, 0);
        }
        int xx = 0;
        int yy = 0;
        int bboxtop = 1 - this.fontInfo.ascent;
        int bboxleft = 0;
        int bboxright = 0;
        int bboxbottom = 0;
        ls = ls != 0 ? (ls -= ls % 16) : this.fontInfo.height;
        int ccs = (int)(cs * 16.0);
        int w = width * 16;
        int i = 0;
        int linebegin = 0;
        int lineend = 0;
        int lastxx = 0;
        int lastadj = 0;
        int nextxx = 0;
        boolean wasbr = false;
        int tlen = text.length();
        do {
            c = i < tlen ? text.charAt(i) : (char)'\u0000';
            FontDescriptor.CharInfo ci = this.fontInfo.getCharInfo(c);
            if (c == ' ' || c == '\u0000' || c == '\n' || c == '-') {
                lineend = i;
                lastxx = xx;
                lastadj = ccs + ci.ix;
                wasbr = true;
            }
            nextxx = xx + ccs + ci.ix;
            if (w != 0 && nextxx > w || c == '\n' || c == '\u0000') {
                int li = linebegin;
                if (!wasbr) {
                    lineend = i;
                    lastxx = xx;
                }
                xx = 0;
                while (li < lineend) {
                    char c2 = text.charAt(li++);
                    ci = this.fontInfo.getCharInfo(c2);
                    int crleft = xx;
                    if (li != linebegin + 1) {
                        crleft += ci.tx;
                    }
                    int crtop = yy - ci.ty;
                    int crright = crleft + ci.ix;
                    int crbottom = crtop + ci.th;
                    bboxleft = this.min3(bboxleft, crleft, crright);
                    bboxright = this.max3(bboxright, crleft, crright);
                    bboxtop = this.min3(bboxtop, crtop, crbottom);
                    bboxbottom = this.max3(bboxbottom, crtop, crbottom);
                    xx += ccs + ci.ix;
                    if (li != linebegin + 1) continue;
                    xx -= ci.tx;
                }
                if (c != '\u0000') {
                    yy += ls;
                }
                linebegin = lineend + (wasbr ? 1 : 0);
                lineend = 0;
                wasbr = false;
                xx = nextxx - lastxx - lastadj;
                lastadj = 0;
            } else {
                xx += ci.ix + ccs;
            }
            ++i;
        } while (c != '\u0000');
        if ((yy += this.fontInfo.descent) > bboxbottom) {
            bboxbottom = yy;
        }
        bboxleft = bboxleft < 0 ? (bboxleft - 15) / 16 + x : (bboxleft + 15) / 16 + x;
        bboxtop = bboxtop < 0 ? (bboxtop - 15) / 16 + y : (bboxtop + 15) / 16 + y;
        bboxright = bboxright < 0 ? (bboxright - 15) / 16 + x : (bboxright + 15) / 16 + x;
        bboxbottom = bboxbottom < 0 ? (bboxbottom - 15) / 16 + y : (bboxbottom + 15) / 16 + y;
        Rectangle r = new Rectangle(bboxleft, bboxtop, bboxright - bboxleft, bboxbottom - bboxtop);
        this.alignRect(r, x, y, align);
        return r;
    }

    @Override
    public int drawText(Layer layer, int x, int y, int width, int height, String text, Paint color, Stroke stroke, int align, double cs, int ls) {
        char c;
        if (text == null || text.length() == 0) {
            this.log.info("drawText: No text to render");
            return 0;
        }
        if ((align & 0x20) != 0) {
            x += width;
        } else if ((align & 0x10) != 0) {
            x += width / 2;
        }
        if ((align & 2) != 0) {
            y += height;
        }
        Rectangle2D bbox = this.getTextExtent(x, y, width, height, text, 68, cs, ls);
        ls = ls != 0 ? (ls -= ls % 16) : this.fontInfo.height;
        int ccs = (int)(cs * 16.0);
        int lw = (int)bbox.getWidth();
        int lh = (int)bbox.getHeight();
        Layer tl = new Layer(lw, lh, TRANSPARENT_BACKGROUND);
        if (color != null) {
            tl.setPaint(color);
        }
        if (stroke != null) {
            tl.setStroke(stroke);
        }
        int linesDrawn = 0;
        int w = width * 16;
        int xx = (x - (int)bbox.getX()) * 16;
        int yy = (y - (int)bbox.getY()) * 16;
        BufferedImage channel = this.fontInfo.fontImage;
        int i = 0;
        int linebegin = 0;
        int lineend = 0;
        int tlen = text.length();
        int lastxx = 0;
        int lastadj = 0;
        boolean wasbr = false;
        do {
            c = i < tlen ? text.charAt(i) : (char)'\u0000';
            FontDescriptor.CharInfo ci = this.fontInfo.getCharInfo(c);
            if (c == ' ' || c == '\u0000' || c == '\n' || c == '-') {
                lineend = i;
                lastxx = xx;
                lastadj = ccs + ci.ix;
                wasbr = true;
            }
            int nextxx = xx + ccs + ci.ix;
            if (w != 0 && nextxx > w || c == '\n' || c == '\u0000') {
                int li = linebegin;
                if (!wasbr) {
                    lineend = i;
                    lastxx = xx;
                }
                xx = (align & 0x20) != 0 ? lw * 16 - lastxx : ((align & 0x10) != 0 ? lw * 8 - lastxx / 2 : (x - (int)bbox.getX()) * 16);
                int lineStart = xx / 16;
                while (li < lineend) {
                    char c2 = text.charAt(li++);
                    ci = this.fontInfo.getCharInfo(c2);
                    int dx = xx;
                    if (li != linebegin + 1) {
                        dx += ci.tx;
                    }
                    int dy = yy - ci.ty;
                    int ce = dx < 0 ? 15 + dx % 16 : dx % 16;
                    dx /= 16;
                    dy /= 16;
                    int sx = ci.cells[ce].x;
                    int sy = ci.cells[ce].y;
                    int sw = ci.cells[ce].w;
                    int sh = ci.cells[ce].h;
                    if (sw != 0 && sh != 0) {
                        BufferedImage rimage = channel.getSubimage(sx, sy, sw, sh);
                        tl.drawImage(rimage, null, dx, dy);
                    }
                    xx += ccs + ci.ix;
                    if (li != linebegin + 1) continue;
                    xx -= ci.tx;
                }
                if ((align & 0x3000) != 0) {
                    int lineEnd = xx / 16;
                    int linePos = yy / 16;
                    if ((align & 0x2000) != 0) {
                        linePos = (int)((double)linePos - this.getAscent() / 3.0);
                    }
                    tl.drawLine(lineStart, linePos, lineEnd, linePos);
                }
                yy += ls;
                linebegin = lineend + (wasbr ? 1 : 0);
                lineend = 0;
                wasbr = false;
                xx = nextxx - lastxx - lastadj;
                lastadj = 0;
                ++linesDrawn;
            } else {
                xx += ci.ix + ccs;
            }
            ++i;
        } while (c != '\u0000');
        this.alignRect(bbox, x, y, align);
        tl.setX((int)(bbox.getX() + 0.5) + layer.getX());
        tl.setY((int)(bbox.getY() + 0.5) + layer.getY());
        int deg = 0;
        if ((align & 0x100) != 0) {
            deg = 90;
        } else if ((align & 0x400) != 0) {
            deg = 180;
        } else if ((align & 0x200) != 0) {
            deg = 270;
        }
        if (deg != 0) {
            tl.rotate(deg);
            if ((align & 0x10) != 0 && (align & 0x300) != 0) {
                tl.setX(tl.getX() + tl.getHeight() / 2 - tl.getWidth() / 2);
            }
        }
        Color col = color instanceof Color ? (Color)color : Color.black;
        WritableRaster tlr = tl.getImage().getRaster();
        float[][] bopEl = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, col.getRed()}, {0.0f, 0.0f, 0.0f, 0.0f, col.getGreen()}, {0.0f, 0.0f, 0.0f, 0.0f, col.getBlue()}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        new BandCombineOp(bopEl, null).filter(tlr, tlr);
        layer.merge(tl);
        return linesDrawn;
    }

    public static List<FontListEntry> getFontList() {
        Logger log = LoggerFactory.getLogger(FonterFont.class);
        ArrayList<FontListEntry> fonts = new ArrayList<FontListEntry>();
        for (String pathEntry : fontPath) {
            Iterator<Resource> children = FonterFont.getChildren(pathEntry);
            while (children.hasNext()) {
                Resource anyResource = children.next();
                String anyPath = anyResource.getPath();
                if (!anyPath.endsWith(".any")) continue;
                try {
                    int style;
                    AnyObject any = FontDescriptor.parseFontAny(anyResource);
                    int lastSlash = anyPath.lastIndexOf(47) + 1;
                    int end = anyPath.lastIndexOf(".any");
                    if (end < 0) {
                        log.error("getFontList: Not finding extension ''.any'' in ''${}''not expected !!! Ignoring page.", (Object)anyPath);
                        continue;
                    }
                    String label = anyPath.substring(lastSlash, end);
                    String facename = ((AnyValue)any.getDirect("facename")).getStringValue();
                    int size = (int)((AnyValue)any.getDirect("size")).getNumberValue();
                    if (!label.equals(facename = FonterFont.createFontFileName(facename, size, style = FonterFont.stringToStyle(((AnyValue)any.getDirect("style")).getStringValue())))) {
                        log.warn("getFontList: Font information file {} has incompatible name, expected {}. Ignoring entry.", (Object)anyPath, (Object)facename);
                        continue;
                    }
                    fonts.add(new FontListEntry("FonterFont", facename, size, style));
                }
                catch (NullPointerException npe) {
                    log.info("getFontList: Font information file {} incomplete", (Object)anyPath);
                }
                catch (ClassCastException cce) {
                    log.info("getFontList: Font information file {} wrong", (Object)anyPath);
                }
                catch (ParseException pe) {
                    log.info("getFontList: Font information file {} corrupt: {}", (Object)anyPath, (Object)pe.toString());
                }
                catch (IOException ioe) {
                    log.info("getFontList: Error reading font information file {}: {}", (Object)anyPath, (Object)ioe.toString());
                }
            }
        }
        return fonts;
    }

    @Override
    public String toString() {
        return "FonterFont[family=" + this.family + ", size=" + this.size + ", style=" + this.style + "]";
    }

    private void alignRect(Rectangle2D rect, int x, int y, int align) {
        double rx = rect.getX();
        double ry = rect.getY();
        double rw = rect.getWidth();
        double rh = rect.getHeight();
        if ((align & 0xF) == 0) {
            ry = y;
        } else if ((align & 2) != 0) {
            ry = (double)y - rh;
        }
        if ((align & 0xF0) == 0) {
            rx = x;
        } else if ((align & 0x20) != 0) {
            rx = (double)x - rw;
        } else if ((align & 0x10) != 0) {
            rx = (double)x - rw / 2.0;
        }
        rect.setRect(rx, ry, rw, rh);
    }

    private int min3(int v0, int v1, int v2) {
        if (v0 < v1) {
            return v0 < v2 ? v0 : v2;
        }
        return v1 < v2 ? v1 : v2;
    }

    private int max3(int v0, int v1, int v2) {
        if (v0 > v1) {
            return v0 > v2 ? v0 : v2;
        }
        return v1 > v2 ? v1 : v2;
    }

    private static Iterator<Resource> getChildren(String pathEntry) {
        Resource parent = ticket.getResource(pathEntry);
        if (parent == null) {
            parent = new SyntheticResource(ticket, pathEntry, "nt:folder");
        }
        return ticket.listChildren(parent);
    }

    static {
        float[][] elements = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 255.0f}, {1.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
        convertToTransparent = new BandCombineOp(elements, null);
    }
}

