/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class FontPath {

    private final GlobPattern[] patterns;
    private final ResourceResolver resolver;

    private String[] currentPath;

    public FontPath(ResourceResolver resolver, String[] patternStrings) {
        this.resolver = resolver;

        patterns = new GlobPattern[patternStrings.length];
        for (int i=0; i < patternStrings.length; i++) {
            patterns[i] = new GlobPattern(patternStrings[i], true);
        }

        // scan on demand
        currentPath = null;
    }

    public String[] getCurrentPath() {
        if (currentPath == null) {
            currentPath = scanPath();
        }
        return currentPath;
    }

    public boolean matches(String path) {
        for (GlobPattern pattern : patterns) {
            if (pattern.matches(path)) {
                return true;
            }
        }

        // no pattern matches the path
        return false;
    }

    private String[] scanPath() {
        List<String> list = new ArrayList<String>();
        for (GlobPattern pattern : patterns) {
            Resource start = getStartResource(pattern);
            if (start != null) {
                recurse(list, pattern, start);
            }
        }

        return list.toArray(new String[list.size()]);
    }

    private void recurse(List<String> list, GlobPattern pattern, Resource start) {
        if (pattern.matches(start.getPath())) {
            list.add(start.getPath());
        } else {
            Iterator<Resource> children = ResourceUtil.listChildren(start);
            while (children.hasNext()) {
                recurse(list, pattern, children.next());
            }
        }
    }

    private Resource getStartResource(GlobPattern pattern) {
        String wcp = "*?[]";
        String ps = pattern.toString();
        int slash = -1;
        for (int i=0; i < ps.length(); i++) {
            char c = ps.charAt(i);
            if (c == '/') {
                slash = i;
            } else if (wcp.indexOf(c) >= 0) {
                break;
            }
        }

        ps = (slash >= 0) ? ps.substring(0, slash) : "/";
        return resolver.getResource(ps);
    }
}
