/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal;

import java.io.PrintWriter;
import java.util.Iterator;

import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.ConfigurationPrinter;

/**
 * The <code>ImageIOPanel</code> is a Web Console plugin to list all registered
 * ImageIO image reader and writer plugins.
 */
@Component
@Service(ConfigurationPrinter.class)
public class ImageIOPanel implements ConfigurationPrinter {

    // the page/configuration titl
    private static final String TITLE = "GFX ImageIO Formats";

    // ---------- ConfigurationPrinter

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Image Reader Provider");
        pw.println("---------------------");
        printReaderWriterSpiTxt(pw, ImageReaderSpi.class);
        pw.println();
        pw.println("Image Writer Provider");
        pw.println("---------------------");
        printReaderWriterSpiTxt(pw, ImageWriterSpi.class);
    }

    private <T extends ImageReaderWriterSpi> void printReaderWriterSpiTxt(
            PrintWriter pw, Class<T> category) {
        Iterator<T> spis = IIORegistry.getDefaultInstance().getServiceProviders(
            category, true);
        while (spis.hasNext()) {
            T spi = spis.next();
            pw.printf("%s (%s, %s): formats: [%s], MIME types: [%s]%n",
                spi.getDescription(null),
                spi.getVersion(),
                spi.getVendorName(),
                format(spi.getFormatNames()),
                format(spi.getMIMETypes()));
        }
    }

    private String format(Object[] values) {
        if (values == null || values.length == 0) {
            return "";
        }

        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Object value : values) {
            buf.append(sep);
            buf.append(value);
            sep = ", ";
        }
        return buf.toString();
    }
}
