/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal;

import java.io.IOException;
import java.io.InputStream;

import javax.imageio.IIOException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;

import com.day.image.Layer;

/**
 * The <code>LayerAdapterFactory</code> adapts any adaptable which can be
 * adapted to an <code>java.io.InputStream</code> to a {@link Layer}.
 */
@Component
@Service
@Properties({
	@Property(name="adaptables", value="org.apache.sling.api.adapter.Adaptable"),
	@Property(name="adapters", value="com.day.image.Layer"),
	@Property(name="adapter.condition", value="If the adaptable can be adapted to an InputStream.")
})
public class LayerAdapterFactory implements AdapterFactory {

    /**
     * Adapts a the adaptable <code>object</code> to a {@link Layer} if the
     * object itself is adaptable to an <code>java.io.InputStream</code>.
     * Otherwise <code>null</code> is returned.
     */
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType getAdapter(Object object,
            Class<AdapterType> type) {

        // this sould be ensured by the AdapterManager, we still check for
        // defensive programming...
        if (type == Layer.class && object instanceof Adaptable) {

            // adapt the object to an InputStream to read the layer from
            Adaptable source = (Adaptable) object;
            InputStream ins = source.adaptTo(InputStream.class);

            if (ins != null) {
                try {

                    return (AdapterType) new Layer(ins);

                } catch (IIOException iioe) {
                    // the source is not an image or some image format error
                    // happened or no decoder for the image type is available

                } catch (IOException ioe) {
                    // a problem reading from the file

                } catch (OutOfMemoryError oome) {
                    // keep clean and cool, though caught by the Layer
                    // constructor, we still try to do all to prevent it from
                    // sifting up the call stack

                } catch (Throwable t) {
                    // don't have this method run havock

                } finally {
                    if (ins != null) {
                        try {
                            ins.close();
                        } catch (IOException ioe) {
                        }
                    }
                }
            }
        }

        // cannot adapt: wrong types or not InputStream-adaptable
        return null;
    }

}
