/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal.font;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/** Provides disk files to be used by the the Font.createFont()
 *  method, to avoid using the variant of that method that uses an
 *  InputStream and creates multiple identical files in the
 *  File.createTempFile() folder.
 */
public interface FontFileProvider {
    /** Get a read-only File for given input stream, reusing files
     *  for InputStreams that have the same digest.
     *  Files returned are kept around until this service is stopped.
     *  @param is closed when done copying to File
     */
    public File getFileForStream(InputStream is) throws IOException;
}
