/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal.font;

import java.io.PrintWriter;
import java.util.List;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.ConfigurationPrinter;

import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;

@Component
@Service(ConfigurationPrinter.class)
public class FontListPanel implements ConfigurationPrinter {

    private static final String TITLE = "GFX supported Fonts";

    public String getTitle() {
        return TITLE;
    }


    // ---------- ConfigurationPrinter

    public void printConfiguration(PrintWriter pw) {
        List<FontListEntry> fonts = FontHelper.getInstance().getFontList();
        for (FontListEntry fontListEntry : fonts) {
            pw.print(fontListEntry.getFacename());
            pw.print(", Style:");
            pw.print(AbstractFont.styleToDescription(fontListEntry.getStyle()));

            if (fontListEntry.getSize() == 0) {
                pw.print(", Scalable TrueType Font");
            } else {
                pw.print(", Size:");
                pw.print(fontListEntry.getSize());
            }
            pw.print(", Provider: ");
            pw.print(fontListEntry.getFontProvider());
            pw.println();
        }

        pw.println();
        pw.println("*** GFX Font Path:");
        String[] fontPath = FontHelper.getInstance().getFontPath();
        for (String fontPathEntry : fontPath) {
            pw.println(fontPathEntry);
        }
    }
}
