/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image.internal.font;

import java.util.List;

import javax.jcr.observation.EventIterator;

import org.apache.sling.api.resource.ResourceResolver;

import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;

/**
 * The <code>FontProvider</code> interface specifies an SPI-like API which is
 * used by the {@link com.day.cq.image.Font} class to ask different font
 * providers for a font satisfying the properties.
 * <p>
 * Default font providers known are the {@link ContentBusFont} class which
 * supports loading TrueType fonts from the ContentBus and the
 * {@link FonterFont} class which supports loading so called FonterFonts from
 * the ContentBus.
 *
 * @version $Revision: 20173 $, $Date: 2006-05-03 16:47:57 +0200 (Mit, 03 Mai
 *          2006) $
 * @author fmeschbe
 * @since degu
 * @audience wad
 */
public interface FontProvider {

    void init(ResourceResolver resolver, String[] fontPath, FontFileProvider ffp);

    void destroy();

    void onEvent(EventIterator events);

    /**
     * Returns the list of available fonts on the platform. For each font found
     * its family name (e.g. Helvetica), point size (??) and style (e.g.
     * Font.BOLD) is returned. Note: We only get the font family names and
     * defined all fonts to be available all styles, as Java2D will create
     * missing styles on the fly.
     *
     * @return List of fonts on the platform
     */
    List<FontListEntry> getFontList();

    /**
     * Tries to load a font with the given face name, size and style flags. If
     * the class represented by this <code>FontProvider</code> cannot provide
     * a font with the indicated properties, the method should return
     * <code>null</code>.
     *
     * @param faceName Name of the font as known to the user. This generally is
     *            not the same as the name of the font file. In fact this MUST
     *            be the name of the Font family. That is "Times New Roman" and
     *            not "Times New Roman Bold" is expected.
     * @param size Size in points for the font to open
     * @param style Style flags for the new font
     * @return The {@link Font} instance according to the given properties or
     *         <code>null</code> if the class represented by the provider
     *         implementation cannot provide a font with the given details.
     */
    AbstractFont getFont(String faceName, int size, int style);

}
