/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.imageio.plugins;

import java.util.Locale;

import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

/**
 * The <code>GifImageWriterSpi</code> class implements the SPI for the
 * {@link GifImageWriter14} class.
 *
 * @version $Revision: 26109 $, $Date: 2007-04-17 16:41:22 +0200 (Di, 17 Apr 2007) $
 * @author fmeschbe
 * @since coati
 * @audience core
 */
public class GifImageWriterSpi extends ImageWriterSpi {

    public GifImageWriterSpi() {
        super(GifImageWriterUtil.vendorName, GifImageWriterUtil.version,
                    GifImageWriterUtil.names, GifImageWriterUtil.suffixes,
                    GifImageWriterUtil.MIMETypes, GifImageWriter.class.getName(),
                    STANDARD_OUTPUT_TYPE, null /* readerSpiNames */,
                    false /* supportsStandardStreamMetadataFormat */,
                    GifImageWriterUtil.nativeStreamMetadataFormatName,
                    GIFStreamMetadata.class.getName(),
                    null /* extra stream meta data names */,
                    null /* extra stream meta data class names */,
                    false /* supportsStandardImageMetadataFormat */,
                    GifImageWriterUtil.nativeImageMetadataFormatName,
                    GIFImageMetadata.class.getName(),
                    null /* extra image meta data names */,
                    null /* extra image meta data class names */);
    }

    public String getDescription(Locale locale) {
        return GifImageWriterUtil.getDescription(locale);
    }

    public ImageWriter createWriterInstance(Object extension)
            throws javax.imageio.IIOException {
        return new GifImageWriter(this);
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return GifImageWriterUtil.canEncodeImage(type);
    }

}