/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal;

import com.day.image.ImageSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
BundleListener {
    private static final String SERVICES_FOLDER = "META-INF/services/";
    private Map<Long, List<Object>> perBundleProvider = new HashMap<Long, List<Object>>();

    public void start(BundleContext context) {
        ImageSupport.registerImageIOSpi();
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.registerImageIOProvider(bundle);
        }
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        IIORegistry reg = IIORegistry.getDefaultInstance();
        for (List<Object> providers : this.perBundleProvider.values()) {
            this.unregisterImageIOProvider(reg, providers);
        }
        ImageSupport.deregisterImageIOSpi();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.registerImageIOProvider(event.getBundle());
                break;
            }
            case 4: {
                this.unregisterImageIOProvider(event.getBundle());
            }
        }
    }

    private void registerImageIOProvider(Bundle bundle) {
        BundleProxyClassLoader loader = new BundleProxyClassLoader(bundle);
        ArrayList<Object> providers = new ArrayList<Object>();
        this.loadProviders(providers, loader, ImageInputStreamSpi.class);
        this.loadProviders(providers, loader, ImageOutputStreamSpi.class);
        this.loadProviders(providers, loader, ImageReaderSpi.class);
        this.loadProviders(providers, loader, ImageWriterSpi.class);
        if (!providers.isEmpty()) {
            IIORegistry reg = IIORegistry.getDefaultInstance();
            this.registerImageIOProvider(reg, providers);
            this.perBundleProvider.put(bundle.getBundleId(), providers);
        }
    }

    private void unregisterImageIOProvider(Bundle bundle) {
        IIORegistry reg = IIORegistry.getDefaultInstance();
        List<Object> providers = this.perBundleProvider.remove(bundle.getBundleId());
        if (providers != null) {
            this.unregisterImageIOProvider(reg, providers);
        }
    }

    private void registerImageIOProvider(IIORegistry reg, List<Object> providers) {
        reg.registerServiceProviders(providers.iterator());
    }

    private void unregisterImageIOProvider(IIORegistry reg, List<Object> providers) {
        for (Object provider : providers) {
            reg.deregisterServiceProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void loadProviders(List<Object> providers, BundleProxyClassLoader bundleLoader, Class<T> spiClass) {
        String entryName = SERVICES_FOLDER + spiClass.getName();
        if (bundleLoader.hasResource(entryName)) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(bundleLoader);
                Iterator<T> spi = ServiceRegistry.lookupProviders(spiClass, bundleLoader);
                while (spi.hasNext()) {
                    try {
                        providers.add(spi.next());
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                        t.printStackTrace(System.err);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleProxyClassLoader
    extends ClassLoader {
        private final Bundle bundle;

        public BundleProxyClassLoader(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }

        boolean hasResource(String name) {
            return this.bundle.getResource(name) != null;
        }
    }
}

