/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal;

import java.io.PrintWriter;
import java.util.Iterator;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.ConfigurationPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={ConfigurationPrinter.class})
public class ImageIOPanel
implements ConfigurationPrinter {
    private static final String TITLE = "GFX ImageIO Formats";

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Image Reader Provider");
        pw.println("---------------------");
        this.printReaderWriterSpiTxt(pw, ImageReaderSpi.class);
        pw.println();
        pw.println("Image Writer Provider");
        pw.println("---------------------");
        this.printReaderWriterSpiTxt(pw, ImageWriterSpi.class);
    }

    private <T extends ImageReaderWriterSpi> void printReaderWriterSpiTxt(PrintWriter pw, Class<T> category) {
        Iterator<T> spis = IIORegistry.getDefaultInstance().getServiceProviders(category, true);
        while (spis.hasNext()) {
            ImageReaderWriterSpi spi = (ImageReaderWriterSpi)spis.next();
            pw.printf("%s (%s, %s): formats: [%s], MIME types: [%s]%n", spi.getDescription(null), spi.getVersion(), spi.getVendorName(), this.format(spi.getFormatNames()), this.format(spi.getMIMETypes()));
        }
    }

    private String format(Object[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Object value : values) {
            buf.append(sep);
            buf.append(value);
            sep = ", ";
        }
        return buf.toString();
    }
}

