/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.arw;

import it.tidalwave.imageio.arw.ARWImageReader;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;

public class ARWImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = ARWImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public ARWImageReaderSpi() {
        super("ARW", "arw", "image/x-sony-arw", ARWImageReader.class);
    }

    public String getDescription(Locale locale) {
        return "Standard ARW Image Reader";
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new ARWImageReader(this, extension);
    }

    public boolean canDecodeInput(RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, null);
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        if (primaryIFD.isDNGVersionAvailable()) {
            return false;
        }
        String make = primaryIFD.getMake();
        String model = primaryIFD.getModel();
        if (make == null || !make.toUpperCase().startsWith("SONY") || model == null || !model.toUpperCase().startsWith("DSLR-A100")) {
            logger.fine("ARWImageReaderSpi giving up on: '%s' / %s'", make, model);
            return false;
        }
        return true;
    }
}

