/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.arw;

import it.tidalwave.imageio.arw.ARWMakerNote;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ARWMetadata
extends TIFFMetadataSupport {
    private static final long serialVersionUID = 3012868418676854749L;
    private final MinoltaRawData minoltaRawData = new MinoltaRawData();

    public ARWMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) throws IOException {
        super(primaryIFD, iis, headerProcessor);
        IFD ifd = (IFD)primaryIFD;
        if (ifd.isDNGPrivateDataAvailable()) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(ifd.getDNGPrivateData());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int offset = byteBuffer.asIntBuffer().get();
            long save = iis.getStreamPosition();
            iis.seek(offset);
            if (iis.read() == 0 && iis.read() == 77 && iis.read() == 82) {
                int order = iis.read();
                this.minoltaRawData.load(iis, offset, order == 73 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            iis.seek(save);
        }
    }

    @Nonnull
    public ARWMakerNote getARWMakerNote() {
        return (ARWMakerNote)this.getMakerNote();
    }

    @Nonnull
    public MinoltaRawData getMinoltaRawData() {
        return this.minoltaRawData;
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return false;
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isJPEGInterchangeFormatAvailable();
    }

    @Nonnegative
    public int getWidth() {
        return this.minoltaRawData.getPRD().getCcdSize().width;
    }

    @Nonnegative
    public int getHeight() {
        return this.minoltaRawData.getPRD().getCcdSize().height;
    }
}

