/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.arw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ARWRasterReader
extends RasterReader {
    protected boolean isCompressedRaster() {
        return true;
    }

    protected void loadCompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = 3 * width;
        this.selectBitReader(iis, raster, this.bitsPerSample);
        iis.seek(this.rasterOffset);
        int sum = 0;
        int x = width;
        while (x-- > 0) {
            for (int y = 0; y < height + 1; y += 2) {
                int diff;
                if (y == height) {
                    y = 1;
                }
                int k = y % 2 * 2;
                int len = 4 - (int)iis.readBits(2);
                if (len == 3 && iis.readBits(1) != 0L) {
                    len = 0;
                }
                if (len == 4) {
                    while (len < 17 && iis.readBit() == 0) {
                        ++len;
                    }
                }
                if (((diff = (int)iis.readBits(len)) & 1 << len - 1) == 0) {
                    diff -= (1 << len) - 1;
                }
                if ((sum += diff) >> 12 != 0) {
                    throw new IOException("sums += diff >> 12 != 0");
                }
                int i = x * 3 + y * scanStride;
                if (y >= height) continue;
                int j = x % 2;
                data[i + this.cfaOffsets[j + k]] = (short)sum;
            }
            ir.processImageProgress(100.0f * (float)(width - x) / (float)width);
        }
    }

    @Nonnull
    public String toString() {
        return "ARWRasterReader";
    }
}

