/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.IFDSupport;

public class CanonCR2MakerNoteSupport
extends IFDSupport {
    private static final long serialVersionUID = 6347805638960118907L;
    public static final TagRegistry REGISTRY = TagRegistry.getRegistry("CanonCR2");
    public static final Object CAMERA_MODEL = REGISTRY.register(6, "Camera Model");
    public static final Object FIRMWARE_VERSION = REGISTRY.register(7, "Firmware Version");
    public static final Object OWNER_NAME = REGISTRY.register(9, "Owner Name");
    public static final Object SERIAL_NUMBER = REGISTRY.register(12, "Serial Number");
    public static final Object CANON_PICTURE_INFO = REGISTRY.register(18, "Canon Picture Info");
    public static final Object SENSOR_INFO = REGISTRY.register(224, "Sensor Info");
    public static final Object WHITE_BALANCE_INFO = REGISTRY.register(16385, "White Balance Info");

    public CanonCR2MakerNoteSupport() {
        super(REGISTRY);
    }

    public boolean isCameraModelAvailable() {
        return this.containsTag(CAMERA_MODEL);
    }

    public String getCameraModel() {
        return this.getString(CAMERA_MODEL);
    }

    public boolean isFirmwareVersionAvailable() {
        return this.containsTag(FIRMWARE_VERSION);
    }

    public String getFirmwareVersion() {
        return this.getString(FIRMWARE_VERSION);
    }

    public boolean isOwnerNameAvailable() {
        return this.containsTag(OWNER_NAME);
    }

    public String getOwnerName() {
        return this.getString(OWNER_NAME);
    }

    public boolean isSerialNumberAvailable() {
        return this.containsTag(SERIAL_NUMBER);
    }

    public int getSerialNumber() {
        return this.getInteger(SERIAL_NUMBER);
    }

    public boolean isCanonPictureInfoAvailable() {
        return this.containsTag(CANON_PICTURE_INFO);
    }

    public int[] getCanonPictureInfo() {
        return this.getIntegers(CANON_PICTURE_INFO);
    }

    public boolean isSensorInfoAvailable() {
        return this.containsTag(SENSOR_INFO);
    }

    public int[] getSensorInfo() {
        return this.getIntegers(SENSOR_INFO);
    }

    public boolean isWhiteBalanceInfoAvailable() {
        return this.containsTag(WHITE_BALANCE_INFO);
    }

    public int[] getWhiteBalanceInfo() {
        return this.getIntegers(WHITE_BALANCE_INFO);
    }
}

