/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.crw.CIFFTag;
import it.tidalwave.imageio.crw.CRWImageInputStream;
import it.tidalwave.imageio.crw.CRWMetadata;
import it.tidalwave.imageio.crw.CRWRasterReader;
import it.tidalwave.imageio.crw.CanonCRWMakerNote;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class CRWImageReader
extends RAWImageReaderSupport {
    private static final String CLASS = CRWImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private int thumbnailCount;
    private boolean jpgFromRawAvailable;
    private boolean thumbnailImageAvailable;
    private IFD imageIFD;
    private IFD exifIFD;
    private CanonCRWMakerNote canonMakerNote;

    protected CRWImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public int getNumThumbnails(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return this.thumbnailCount;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return ((CRWMetadata)this.metadata).getImageWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return ((CRWMetadata)this.metadata).getImageHeight();
    }

    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        return ((CRWMetadata)this.metadata).getThumbnailWidth();
    }

    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        return ((CRWMetadata)this.metadata).getThumbnailHeight();
    }

    protected Directory loadPrimaryDirectory() throws IOException {
        logger.info("loadPrimaryDirectory() - iis: %s", this.iis);
        long directoryOffset = CRWImageReader.processHeader(this.iis, true);
        this.primaryDirectory = new CanonCRWMakerNote();
        this.primaryDirectory.loadAll(this.iis, directoryOffset);
        return this.primaryDirectory;
    }

    protected BufferedImage loadThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        logger.info("loadThumbnail(%d, %d) - iis: %s", imageIndex, thumbnailIndex, this.iis);
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        this.checkThumbnailIndex(thumbnailIndex);
        CanonCRWMakerNote crwMakerNote = (CanonCRWMakerNote)this.primaryDirectory;
        int jpegOffset = 0;
        int jpegSize = 0;
        if (this.thumbnailImageAvailable && thumbnailIndex == 0) {
            CIFFTag thumbTag = (CIFFTag)crwMakerNote.getTag(CanonCRWMakerNote.THUMBNAIL_IMAGE);
            jpegOffset = thumbTag.getOffset() + thumbTag.getBaseOffset();
            jpegSize = thumbTag.getSize();
            logger.fine(">>>> using thumbnail", new Object[0]);
        } else {
            CIFFTag jpgTag = (CIFFTag)crwMakerNote.getTag(CanonCRWMakerNote.JPG_FROM_RAW);
            jpegOffset = jpgTag.getOffset() + jpgTag.getBaseOffset();
            jpegSize = jpgTag.getSize();
            logger.fine(">>>> using jpgFromRaw", new Object[0]);
        }
        return CRWImageReader.loadEmbeddedImage(this.iis, jpegOffset, jpegSize);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        CRWMetadata crwMetadata = (CRWMetadata)this.metadata;
        CRWRasterReader rasterReader = CRWRasterReader.getInstance(crwMetadata.getModel());
        rasterReader.setWidth(crwMetadata.getSensorWidth());
        rasterReader.setHeight(crwMetadata.getSensorHeight());
        rasterReader.setBitsPerSample(12);
        rasterReader.setCFAPattern(new byte[]{0, 1, 1, 2});
        int[] decoderTable = crwMetadata.getDecoderTable();
        rasterReader.setRasterOffset(decoderTable[2]);
        rasterReader.setDecoderPairIndex(decoderTable[0]);
        rasterReader.setStripByteCount(1);
        rasterReader.setCompression(0);
        logger.fine(">>>> using RasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.fine(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }

    protected void checkThumbnailIndex(int thumbnailIndex) {
        if (thumbnailIndex >= this.thumbnailCount) {
            throw new IndexOutOfBoundsException("Invalid thumbnail index: " + thumbnailIndex);
        }
    }

    protected void processMetadata() throws IOException {
        this.primaryDirectory = this.loadPrimaryDirectory();
        logger.fine("PRIMARY DIRECTORY: %s", this.primaryDirectory);
        CanonCRWMakerNote crwMakerNote = (CanonCRWMakerNote)this.primaryDirectory;
        this.thumbnailImageAvailable = crwMakerNote.isThumbnailImageAvailable();
        this.jpgFromRawAvailable = crwMakerNote.isJpgFromRawAvailable();
        if (this.thumbnailImageAvailable) {
            ++this.thumbnailCount;
        }
        if (this.jpgFromRawAvailable) {
            ++this.thumbnailCount;
        }
        this.tryToReadEXIFFromTHM();
        this.metadata = this.createMetadata(this.primaryDirectory, this.imageIFD);
        logger.fine(">>>> metadata: %s", this.metadata);
    }

    protected void disposeAll() {
        super.disposeAll();
        this.exifIFD = null;
        this.imageIFD = null;
    }

    protected Object wrapInput(Object input) {
        try {
            return new CRWImageInputStream((ImageInputStream)input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToReadEXIFFromTHM() throws IOException {
        CRWImageInputStream iis = (CRWImageInputStream)this.iis;
        long fileOffsetSave = iis.getBaseOffset();
        try {
            if (iis.switchToTHMStream()) {
                iis.setBaseOffset(12L);
                iis.seek(0L);
                long directoryOffset = TIFFImageReaderSupport.processHeader(iis, null);
                this.imageIFD = new IFD();
                this.imageIFD.loadAll(iis, directoryOffset);
                logger.finer("THM PRIMARY IFD: %s", this.imageIFD);
                this.processEXIFAndMakerNote(this.imageIFD, iis);
            }
        }
        finally {
            iis.switchToCRWStream();
            iis.setBaseOffset(fileOffsetSave);
        }
    }

    protected void processEXIFAndMakerNote(Directory directory, RAWImageInputStream iis) throws IOException {
        if (((IFD)directory).isExifIFDPointerAvailable()) {
            this.exifIFD = new IFD();
            this.exifIFD.loadAll(iis, ((IFD)directory).getExifIFDPointer());
            this.imageIFD.addNamedDirectory("EXIF", this.exifIFD);
            logger.fine("EXIF IFD: %s", this.exifIFD);
            if (this.exifIFD.isMakerNoteAvailable()) {
                this.processMakerNote(iis);
            }
            if (this.exifIFD.isInteroperabilityIFDAvailable()) {
                IFD interoperabilityIFD = new IFD();
                interoperabilityIFD.loadAll(iis, this.exifIFD.getInteroperabilityIFD());
                logger.fine("Interoperability IFD: %s", interoperabilityIFD);
            }
        }
    }

    protected RAWMetadataSupport createMetadata(Directory primaryDirectory, Directory imageDirector) {
        return new CRWMetadata((CanonCRWMakerNote)primaryDirectory, imageDirector, this.iis, this.headerProcessor);
    }

    protected void processMakerNote(RAWImageInputStream iis) throws IOException {
        int makerNoteOffset = this.exifIFD.getMakerNoteOffset();
        this.makerNote = new CanonCRWMakerNote();
        this.makerNote.load(iis, makerNoteOffset);
        this.exifIFD.addNamedDirectory("MakerNote", this.makerNote);
        logger.fine("MakerNote: %s", this.makerNote);
    }

    private static long processHeader(ImageInputStream iis, boolean reset) throws IOException {
        logger.fine("processHeader(iis=%s, reset=%s)", iis, reset);
        if (reset) {
            iis.seek(0L);
        }
        logger.finest(">>>> reading byte order at %d", iis.getStreamPosition());
        TIFFImageReaderSupport.setByteOrder(iis);
        long offset = iis.readUnsignedInt();
        logger.finer(">>>> processHeader() returning offset is %d", offset);
        return offset;
    }
}

