/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.decoder.HuffmannDecoder;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class CRWRasterReader
extends RasterReader {
    private static final String CLASS = CRWRasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int HEADER_SIZE = 26;
    private static final int BLOCK_WIDTH = 8;
    private static final int BLOCK_HEIGHT = 8;
    private int rasterOffset = -1;
    private int decoderPairIndex = -1;
    private static final HuffmannDecoder[][] canonDecoders;
    private static final short[][] firstDecoderConfiguration;
    private static final short[][] secondDecoderConfiguration;

    public void setRasterOffset(int rasterOffset) {
        this.rasterOffset = rasterOffset;
    }

    public void setDecoderPairIndex(int decoderPairIndex) {
        this.decoderPairIndex = decoderPairIndex;
    }

    public static CRWRasterReader getInstance(String model) {
        if (!model.startsWith("Canon EOS") && !model.startsWith("Canon PowerShot")) {
            throw new IllegalArgumentException("Unsupported model: " + model);
        }
        return new CRWRasterReader();
    }

    protected boolean isCompressedRaster() {
        return true;
    }

    protected void loadCompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        int lowBitsOffset;
        assert (this.rasterOffset >= 0) : "rasterOffset not set";
        assert (this.decoderPairIndex >= 0) : "decoderPairIndex not set";
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * pixelStride;
        iis.selectBitReader(-1, 0);
        int rawOffset = lowBitsOffset = 26 + this.rasterOffset;
        boolean hasLowBits = CRWRasterReader.hasLowBits(iis, rawOffset);
        if (hasLowBits) {
            rawOffset += height * width / 4;
            iis.setSkipZeroAfterFF(true);
        }
        iis.seek(rawOffset);
        HuffmannDecoder[] decoderPair = canonDecoders[this.decoderPairIndex];
        logger.finest(">>>> decoderTable: %d, lowBitsOffset: %d, rawOffset: %d", this.decoderPairIndex, lowBitsOffset, rawOffset);
        logger.finest("firstDecoder: %s", decoderPair[0]);
        logger.finest("secondDecoder: %s", decoderPair[1]);
        int[] diffBlock = new int[64];
        short[] pixel = new short[width * 8];
        int[] base = new int[2];
        int carry = 0;
        int pixelCounter = 0;
        for (int y = 0; y < height; y += 8) {
            int i;
            for (int block = 0; block < width / 8; ++block) {
                this.loadBlock(iis, diffBlock, decoderPair);
                diffBlock[0] = diffBlock[0] + carry;
                carry = diffBlock[0];
                for (i = 0; i < diffBlock.length; ++i) {
                    if (pixelCounter++ % width == 0) {
                        base[1] = 512;
                        base[0] = 512;
                    }
                    int n = i & 1;
                    int n2 = base[n] + diffBlock[i];
                    base[n] = n2;
                    pixel[block * diffBlock.length + i] = (short)n2;
                }
            }
            if (hasLowBits) {
                this.loadLowBits(iis, width, pixel, y);
            }
            for (int y2 = y; y2 < Math.min(y + 8, height); ++y2) {
                i = y2 * scanStride;
                for (int x = 0; x < width; ++x) {
                    int cfaIndex = 2 * (y2 & 1) + (x & 1);
                    data[i + this.cfaOffsets[cfaIndex]] = pixel[(y2 - y) * width + x];
                    i += pixelStride;
                }
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
    }

    private void loadBlock(RAWImageInputStream iis, int[] diffBlock, HuffmannDecoder[] decoderPair) throws IOException {
        int value;
        int i;
        for (i = 0; i < diffBlock.length; ++i) {
            diffBlock[i] = 0;
        }
        for (i = 0; i < diffBlock.length && ((value = decoderPair[i == 0 ? 0 : 1].decode(iis)) != 0 || i == 0); ++i) {
            if (value == 255) continue;
            i += value >> 4;
            int length = value & 0xF;
            if (length <= 0) continue;
            int diff = iis.readComplementedBits(length);
            if (i >= diffBlock.length) continue;
            diffBlock[i] = diff;
        }
    }

    private void loadLowBits(ImageInputStream iis, int width, short[] pixel, int row) throws IOException {
        iis.mark();
        iis.seek(26 + row * width / 4);
        int p = 0;
        for (int i = 0; i < width * 2; ++i) {
            byte c = iis.readByte();
            int r = 0;
            while (r < 8) {
                int val = (pixel[p] << 2) + (c >> r & 3);
                if (width == 2672 && val < 512) {
                    val += 2;
                }
                pixel[p] = (short)val;
                r += 2;
                ++p;
            }
        }
        iis.reset();
    }

    private static boolean hasLowBits(ImageInputStream iis, int offset) throws IOException {
        byte[] buffer = new byte[16384];
        boolean compressed = true;
        iis.seek(0L);
        iis.readFully(buffer);
        for (int i = offset; i < buffer.length - 1; ++i) {
            if (buffer[i] != 255) continue;
            if (buffer[i + 1] != 0) {
                return true;
            }
            compressed = false;
        }
        return compressed;
    }

    static {
        firstDecoderConfiguration = new short[][]{{0, 1, 4, 2, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 5, 6, 2, 7, 1, 8, 9, 0, 10, 11, 255}, {0, 2, 2, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 2, 4, 1, 5, 0, 6, 7, 9, 8, 10, 11, 255}, {0, 0, 6, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 5, 7, 4, 8, 3, 9, 2, 0, 10, 1, 11, 255}};
        secondDecoderConfiguration = new short[][]{{0, 2, 2, 2, 1, 4, 2, 1, 2, 5, 1, 1, 0, 0, 0, 139, 3, 4, 2, 5, 1, 6, 7, 8, 18, 19, 17, 20, 9, 21, 34, 0, 33, 22, 10, 240, 35, 23, 36, 49, 50, 24, 25, 51, 37, 65, 52, 66, 53, 81, 54, 55, 56, 41, 121, 38, 26, 57, 86, 87, 40, 39, 82, 85, 88, 67, 118, 89, 119, 84, 97, 249, 113, 120, 117, 150, 151, 73, 183, 83, 215, 116, 182, 152, 71, 72, 149, 105, 153, 145, 250, 184, 104, 181, 185, 214, 247, 216, 103, 70, 69, 148, 137, 248, 129, 213, 246, 180, 136, 177, 42, 68, 114, 217, 135, 102, 212, 245, 58, 167, 115, 169, 168, 134, 98, 199, 101, 200, 201, 161, 244, 209, 233, 90, 146, 133, 166, 231, 147, 232, 193, 198, 122, 100, 225, 74, 106, 230, 179, 241, 211, 165, 138, 178, 154, 186, 132, 164, 99, 229, 197, 243, 210, 196, 130, 170, 218, 228, 242, 202, 131, 163, 162, 195, 234, 194, 226, 227, 255, 255}, {0, 2, 2, 1, 4, 1, 4, 1, 3, 3, 1, 0, 0, 0, 0, 140, 2, 3, 1, 4, 5, 18, 17, 6, 19, 7, 8, 20, 34, 9, 33, 0, 35, 21, 49, 50, 10, 22, 240, 36, 51, 65, 66, 25, 23, 37, 24, 81, 52, 67, 82, 41, 53, 97, 57, 113, 98, 54, 83, 38, 56, 26, 55, 129, 39, 145, 121, 85, 69, 40, 114, 89, 161, 177, 68, 105, 84, 88, 209, 250, 87, 225, 241, 185, 73, 71, 99, 106, 249, 86, 70, 168, 42, 74, 120, 153, 58, 117, 116, 134, 101, 193, 118, 182, 150, 214, 137, 133, 201, 245, 149, 180, 199, 247, 138, 151, 184, 115, 183, 216, 217, 135, 167, 122, 72, 130, 132, 234, 244, 166, 197, 90, 148, 164, 198, 146, 195, 104, 181, 200, 228, 229, 230, 233, 162, 163, 227, 194, 102, 103, 147, 170, 212, 213, 231, 248, 136, 154, 215, 119, 196, 100, 226, 152, 165, 202, 218, 232, 243, 246, 169, 178, 179, 242, 210, 131, 186, 211, 255, 255}, {0, 0, 6, 2, 1, 3, 3, 2, 5, 1, 2, 2, 8, 10, 0, 117, 4, 5, 3, 6, 2, 7, 1, 8, 9, 18, 19, 20, 17, 21, 10, 22, 23, 240, 0, 34, 33, 24, 35, 25, 36, 50, 49, 37, 51, 56, 55, 52, 53, 54, 57, 121, 87, 88, 89, 40, 86, 120, 39, 65, 41, 119, 38, 66, 118, 153, 26, 85, 152, 151, 249, 72, 84, 150, 137, 71, 183, 73, 250, 117, 104, 182, 103, 105, 185, 184, 216, 82, 215, 136, 181, 116, 81, 70, 217, 248, 58, 214, 135, 69, 122, 149, 213, 246, 134, 180, 169, 148, 83, 42, 168, 67, 245, 247, 212, 102, 167, 90, 68, 138, 201, 232, 200, 231, 154, 106, 115, 74, 97, 199, 244, 198, 101, 233, 114, 230, 113, 145, 147, 166, 218, 146, 133, 98, 243, 197, 178, 164, 132, 186, 100, 165, 179, 210, 129, 229, 211, 170, 196, 202, 242, 177, 228, 209, 131, 99, 234, 195, 226, 130, 241, 163, 194, 161, 193, 227, 162, 225, 255, 255}};
        canonDecoders = new HuffmannDecoder[firstDecoderConfiguration.length][];
        for (int i = 0; i < canonDecoders.length; ++i) {
            CRWRasterReader.canonDecoders[i] = new HuffmannDecoder[2];
            CRWRasterReader.canonDecoders[i][0] = HuffmannDecoder.createDecoder(firstDecoderConfiguration[i]);
            CRWRasterReader.canonDecoders[i][1] = HuffmannDecoder.createDecoder(secondDecoderConfiguration[i]);
        }
    }
}

