/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.crw.CIFFTag;
import it.tidalwave.imageio.crw.CanonCRWMakerNoteSupport;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class CanonCRWMakerNote
extends CanonCRWMakerNoteSupport {
    private static final String CLASS = CanonCRWMakerNote.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static Properties lensNameByID = new Properties();

    public void loadAll(RAWImageInputStream iis, long directoryOffset) throws IOException {
        logger.fine("loadAll(%s, %d)", iis, directoryOffset);
        this.loadAll(iis, directoryOffset, 0);
    }

    private void loadAll(RAWImageInputStream iis, long directoryOffset, int size) throws IOException {
        logger.fine("loadAll(%s, %d, %d)", iis, directoryOffset, size);
        if (size <= 0) {
            iis.seek(iis.length() - 4L);
        } else {
            iis.seek(directoryOffset + (long)size - 4L);
        }
        int dirStart = iis.readInt();
        logger.finer(">>>>>>>> dirStart: %d", dirStart);
        iis.seek(directoryOffset + (long)dirStart);
        int tagCount = iis.readShort();
        logger.finer(">>>>>>>> tagCount: %d", tagCount);
        ArrayList<CIFFTag> subDirectoryList = new ArrayList<CIFFTag>();
        for (int i = 0; i < tagCount; ++i) {
            int tagCode = iis.readUnsignedShort();
            CIFFTag tag = new CIFFTag(this.getRegistry(), tagCode, (int)directoryOffset);
            tag.read(iis);
            this.addTag(tag);
            if (!tag.isSubDirectory()) continue;
            subDirectoryList.add(tag);
        }
        logger.finest(">>>> %d fields read: %s", tagCount, this);
        CanonCRWMakerNote currentMakerNote = this;
        for (CIFFTag tag : subDirectoryList) {
            int offset = tag.getOffset();
            int size2 = tag.getSize();
            CanonCRWMakerNote subDirectory = new CanonCRWMakerNote();
            subDirectory.loadAll(iis, directoryOffset + (long)offset, size2);
            currentMakerNote.addDirectory(subDirectory);
            if (tag.getCode() != 12299) continue;
            logger.finer("CanonMakerNote: %s", subDirectory);
            currentMakerNote = subDirectory;
        }
        logger.fine(">>>> loadAll() completed ok", new Object[0]);
    }

    public int getLensType() {
        return this.getCanonCameraSettings()[22];
    }

    public String getLensName() {
        return lensNameByID.getProperty("" + this.getLensType());
    }

    static {
        try {
            InputStream is = CanonCRWMakerNote.class.getResourceAsStream("CanonLens.properties");
            lensNameByID.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

