/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.decoder;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class HuffmannDecoder {
    private static final int LEAVES_OFFSET = 16;
    private static int leafCounter;
    public HuffmannDecoder[] branch = new HuffmannDecoder[2];
    private int leafValue;

    private HuffmannDecoder() {
    }

    public static HuffmannDecoder createDecoder(short[] source) {
        byte[] bytes = new byte[source.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)source[i];
        }
        return HuffmannDecoder.createDecoder(bytes, 0);
    }

    public static HuffmannDecoder createDecoder(byte[] source, int start) {
        leafCounter = 0;
        return HuffmannDecoder.createDecoder(source, start, 0, false);
    }

    public static HuffmannDecoder createDecoderWithJpegHack(byte[] source, int start) {
        leafCounter = 0;
        return HuffmannDecoder.createDecoder(source, start, 0, true);
    }

    private static HuffmannDecoder createDecoder(byte[] source, int start, int level, boolean jpgHack) {
        HuffmannDecoder dest = new HuffmannDecoder();
        HuffmannDecoder.createDecoder(dest, source, start, level, jpgHack);
        return dest;
    }

    private static void createDecoder(HuffmannDecoder dest, byte[] source, int start, int level, boolean jpgHack) {
        int i;
        int next = 0;
        for (i = 0; i <= leafCounter && next < 16; i += source[start + next++] & 0xFF) {
        }
        if (!(level >= next || jpgHack && next >= 16)) {
            dest.branch[0] = HuffmannDecoder.createDecoder(source, start, level + 1, jpgHack);
            dest.branch[1] = HuffmannDecoder.createDecoder(source, start, level + 1, jpgHack);
        } else if ((i = start + 16 + leafCounter++) < source.length) {
            dest.leafValue = source[i] & 0xFF;
        }
    }

    public int decode(ImageInputStream br) throws IOException {
        HuffmannDecoder d = this;
        while (d.branch[0] != null) {
            d = d.branch[(int)br.readBits(1)];
        }
        return d.leafValue;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buffer = new StringBuffer();
        if (this.branch[0] == null) {
            buffer.append(prefix + ": 0x" + Integer.toHexString(this.leafValue) + "\n");
        } else {
            buffer.append(this.branch[0].toString(prefix + "0"));
            buffer.append(this.branch[1].toString(prefix + "1"));
        }
        return buffer.toString();
    }
}

