/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.decoder;

import it.tidalwave.imageio.decoder.HuffmannDecoder;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class LosslessJPEGDecoder {
    private static final String CLASS = "it.tidalwave.imageio.decoder.LosslessJPEGDecoder";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.decoder.LosslessJPEGDecoder");
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    private int bitsPerSample;
    private int height;
    private int width;
    private int channelCount;
    private int rowSize;
    private int[] vPredictors;
    private HuffmannDecoder[] decoders = new HuffmannDecoder[4];
    private short[] rowBuffer;

    /*
     * Enabled aggressive block sorting
     */
    public void reset(ImageInputStream iis) throws IOException {
        short magic = iis.readShort();
        if (magic != -40) {
            throw new RuntimeException("Bad magic: " + Integer.toHexString(magic & 0xFFFF));
        }
        while (true) {
            short tag = iis.readShort();
            int length = iis.readShort() - 2;
            logger.finer(">>>> tag: %s length: %d", Integer.toHexString(tag & 0xFFFF), length);
            if ((tag & 0xFFFF) <= 65280) throw new RuntimeException("Bad tag:" + Integer.toHexString(tag & 0xFFFF));
            if (length > 255) {
                throw new RuntimeException("Bad tag:" + Integer.toHexString(tag & 0xFFFF));
            }
            switch (tag) {
                case -61: {
                    this.bitsPerSample = iis.readByte() & 0xFF;
                    this.height = iis.readShort() & 0xFFFF;
                    this.width = iis.readShort() & 0xFFFF;
                    this.channelCount = iis.readByte() & 0xFF;
                    this.rowSize = this.width * this.channelCount;
                    iis.skipBytes(length - 6);
                    this.rowBuffer = new short[this.rowSize];
                    this.vPredictors = new int[this.channelCount];
                    for (int i = 0; i < this.channelCount; ++i) {
                        this.vPredictors[i] = 1 << this.bitsPerSample - 1;
                    }
                    logger.fine("bitsPerSample: %d, height: %d, width: %d, channelCount: %d", this.bitsPerSample, this.height, this.rowSize, this.channelCount);
                    break;
                }
                case -60: {
                    int decoderLen;
                    byte[] data = new byte[length];
                    iis.readFully(data);
                    for (int scan = 0; scan < length && data[scan] < 4; scan += decoderLen) {
                        byte channel = data[scan++];
                        decoderLen = 16;
                        for (int q = scan; q < scan + 16; decoderLen += data[q], ++q) {
                        }
                        byte[] temp = new byte[decoderLen];
                        System.arraycopy(data, scan, temp, 0, temp.length);
                        this.decoders[channel] = HuffmannDecoder.createDecoderWithJpegHack(temp, 0);
                        logger.fine("Decoder[%d] = %s", channel, this.decoders[channel]);
                    }
                    break;
                }
                case -38: {
                    iis.skipBytes(length);
                    return;
                }
            }
        }
    }

    public short[] loadRow(RAWImageInputStream iis) throws IOException {
        int scan = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int c = 0; c < this.channelCount; ++c) {
                int n;
                int bitCount = this.decoders[c].decode(iis);
                int diff = iis.readComplementedBits(bitCount);
                if (x == 0) {
                    int n2 = c;
                    n = this.vPredictors[n2] = this.vPredictors[n2] + diff;
                } else {
                    n = this.rowBuffer[scan - this.channelCount] + diff;
                }
                this.rowBuffer[scan] = (short)n;
                ++scan;
            }
        }
        return this.rowBuffer;
    }
}

