/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.dng;

import it.tidalwave.imageio.dng.DNGMetadata;
import it.tidalwave.imageio.dng.DNGRasterReader;
import it.tidalwave.imageio.makernote.LeicaMakerNote;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;

public class DNGImageReader
extends TIFFImageReaderSupport {
    private static Logger logger = Logger.getLogger("it.tidalwave.imageio.dng.DNGImageReader");

    protected DNGImageReader(ImageReaderSpi originatingProvider, Object extension) {
        super(originatingProvider, IFD.class, DNGMetadata.class);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        IFD rasterIFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        DNGRasterReader rasterReader = new DNGRasterReader();
        int width = rasterIFD.getImageWidth();
        int height = rasterIFD.getImageLength();
        int bitsPerSample = rasterIFD.getBitsPerSample()[0];
        this.initializeRasterReader(width, height, bitsPerSample, rasterReader);
        if (!rasterIFD.isTileWidthAvailable()) {
            this.iis.seek(rasterIFD.getStripOffsets());
        }
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.fine(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }

    protected void processMakerNote() throws IOException {
        String make = ((IFD)this.primaryDirectory).getMake();
        if (make != null && "Leica Camera AG".equals(make = make.trim())) {
            this.makerNoteClass = LeicaMakerNote.class;
        }
        super.processMakerNote();
    }
}

