/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import it.tidalwave.imageio.io.BitReader;
import it.tidalwave.imageio.io.FastBitReader;
import it.tidalwave.imageio.io.SixteenBitsReader;
import it.tidalwave.imageio.io.TwelveBitsReader;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class RAWImageInputStream
extends ImageInputStreamImpl {
    private static final String CLASS = RAWImageInputStream.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnegative
    private long baseOffset;
    @Nonnull
    protected ImageInputStream delegate;
    @CheckForNull
    private BitReader bitReader;
    private boolean dontClose;

    public RAWImageInputStream(@Nonnull ImageInputStream delegate) {
        this.delegate = delegate;
    }

    public void setBaseOffset(long baseOffset) {
        this.baseOffset = baseOffset;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public void selectBitReader(@Nonnegative int bitCount, @Nonnegative int bufferSize) {
        if (bufferSize == 0) {
            bufferSize = 65536;
        }
        this.bitReader = bitCount == 12 ? new TwelveBitsReader(this.delegate, bufferSize) : (bitCount == 16 ? new SixteenBitsReader(this.delegate, bufferSize) : new FastBitReader(this.delegate, bufferSize));
        logger.finest(">>>> Using bitReader: %s", this.bitReader);
    }

    public void setSkipZeroAfterFF(boolean b) {
        assert (this.bitReader != null) : "null bitReader";
        this.bitReader.setSkipZeroAfterFF(b);
    }

    public final int readComplementedBits(@Nonnegative int bitsToGet) throws IOException {
        int value = (int)this.readBits(bitsToGet);
        if ((value & 1 << bitsToGet - 1) == 0) {
            value -= (1 << bitsToGet) - 1;
        }
        return value;
    }

    public final void skipBits(@Nonnegative int bitsToSkip) throws IOException {
        assert (this.bitReader != null) : "null bitReader";
        this.bitReader.skipBits(bitsToSkip);
    }

    public String toString() {
        return String.format("RAWImageInputStream[%s, %s]", this.bitReader, this.delegate);
    }

    public final int readBit() throws IOException {
        return this.bitReader != null ? this.bitReader.readBits(1) : this.delegate.readBit();
    }

    public final long readBits(int numBits) throws IOException {
        return this.bitReader != null ? (long)this.bitReader.readBits(numBits) : this.delegate.readBits(numBits);
    }

    public void seek(long pos) throws IOException {
        if (this.bitReader != null) {
            this.bitReader.seek(pos + this.baseOffset);
        } else {
            this.delegate.seek(pos + this.baseOffset);
        }
    }

    public long getStreamPosition() throws IOException {
        return (this.bitReader != null ? this.bitReader.getStreamPosition() : this.delegate.getStreamPosition()) - this.baseOffset;
    }

    public int getBitOffset() throws IOException {
        return this.bitReader != null ? this.bitReader.getBitOffset() : this.delegate.getBitOffset();
    }

    public void setBitOffset(int bitOffset) throws IOException {
        if (this.bitReader != null) {
            this.bitReader.setBitOffset(bitOffset);
        } else {
            this.delegate.setBitOffset(bitOffset);
        }
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    public long length() {
        try {
            return this.delegate.length() - this.baseOffset;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    public long skipBytes(long n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    public void flushBefore(long pos) throws IOException {
        this.delegate.flushBefore(pos + this.baseOffset);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public long getFlushedPosition() {
        return this.delegate.getFlushedPosition();
    }

    public boolean isCached() {
        return this.delegate.isCached();
    }

    public boolean isCachedMemory() {
        return this.delegate.isCachedMemory();
    }

    public boolean isCachedFile() {
        return this.delegate.isCachedFile();
    }

    public void close() throws IOException {
    }

    public void setDontClose() {
        this.dontClose = true;
    }
}

