/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.nef.NEFHeaderProcessor;
import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NEFRasterReader;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class NEFImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = NEFImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private boolean isNDF = false;

    protected NEFImageReader(@Nonnull ImageReaderSpi originatingProvider, @CheckForNull Object extension) {
        super(originatingProvider, NikonMakerNote3.class, NEFMetadata.class);
        this.headerProcessor = new NEFHeaderProcessor();
    }

    protected BufferedImage loadImage(@Nonnull int imageIndex) throws IOException {
        BufferedImage image;
        logger.fine("loadImage(%d) - iis: %s", imageIndex, this.iis);
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        IFD rasterIFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        IFDGenerated.Compression compression = null;
        if (rasterIFD != null && rasterIFD.isCompressionAvailable()) {
            compression = rasterIFD.getCompression();
        }
        if (compression == IFDGenerated.Compression.OJPEG) {
            int offset = rasterIFD.getJPEGInterchangeFormat();
            int length = rasterIFD.getJPEGInterchangeFormatLength();
            image = NEFImageReader.loadEmbeddedImage(this.iis, offset + this.headerProcessor.getOffset(), length);
        } else {
            image = this.loadRAWImage();
        }
        logger.fine(">>>> loadImage() completed ok, returning " + image, new Object[0]);
        return image;
    }

    @Nonnull
    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        IFD primaryIFD = (IFD)this.primaryDirectory;
        IFD rasterIFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        IFD exifIFD = ((TIFFMetadataSupport)this.metadata).getExifIFD();
        IFD thumbnailIFD = ((TIFFMetadataSupport)this.metadata).getThumbnailHelper()[0].ifd;
        NikonMakerNote3 nikonMakerNote = (NikonMakerNote3)this.makerNote;
        long time = System.currentTimeMillis();
        int offset = !this.isNDF ? rasterIFD.getStripOffsets() : thumbnailIFD.getJPEGInterchangeFormat() + thumbnailIFD.getJPEGInterchangeFormatLength();
        this.iis.seek(offset);
        int bitsPerSample = !this.isNDF ? rasterIFD.getBitsPerSample()[0] : exifIFD.getCompressedBitsPerPixel().intValue();
        String model = primaryIFD.getModel();
        NEFRasterReader rasterReader = NEFRasterReader.getInstance(model, this.isNDF);
        int width = !this.isNDF ? rasterIFD.getImageWidth() : exifIFD.getPixelXDimension();
        int height = !this.isNDF ? rasterIFD.getImageLength() : exifIFD.getPixelYDimension();
        this.initializeRasterReader(width, height, bitsPerSample, rasterReader);
        if (nikonMakerNote.isCompressionDataAvailable()) {
            rasterReader.setLinearizationTable(nikonMakerNote.getLinearizationTable());
            rasterReader.setVPredictor(nikonMakerNote.getVPredictor());
        }
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec.", System.currentTimeMillis() - time);
        return raster;
    }

    protected void processMetadata() throws IOException {
        this.iis.setBaseOffset(this.headerProcessor.getOffset());
        this.isNDF = this.iis.getBaseOffset() != 0L;
        super.processMetadata();
    }
}

