/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.nef.NEFHeaderProcessor;
import it.tidalwave.imageio.nef.NEFImageReader;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageReader;

public class NEFImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = NEFImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final List supportedModels = Arrays.asList("E5700", "E8700", "E5400", "E8800");

    public NEFImageReaderSpi() {
        super("NEF", new String[]{"nef", "ndf"}, "image/x-nikon-nef", NEFImageReader.class);
    }

    @Nonnull
    public String getDescription(Locale locale) {
        return "Standard NEF Image Reader";
    }

    @Nonnull
    public ImageReader createReaderInstance(@CheckForNull Object extension) throws IOException {
        return new NEFImageReader(this, extension);
    }

    protected boolean canDecodeInput(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        NEFHeaderProcessor headerProcessor = new NEFHeaderProcessor();
        headerProcessor.process(iis);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, headerProcessor);
        if (ifdOffset == 20L) {
            ifdOffset -= 12L;
            iis.setBaseOffset(12L);
        }
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        if (primaryIFD.isDNGVersionAvailable()) {
            logger.finest(">>>> FAILING, isDNGVersionAvailable returning true", new Object[0]);
            return false;
        }
        String make = primaryIFD.getMake();
        String model = primaryIFD.getModel();
        logger.finest("Make: %s, Model: %s", make, model);
        if (make == null || !make.toUpperCase().startsWith("NIKON") || model == null || !model.toUpperCase().startsWith("NIKON D") && !supportedModels.contains(model.toUpperCase())) {
            logger.finest(">>>> FAILING, supportedModels: %s", supportedModels);
            return false;
        }
        return true;
    }
}

